package com.wisedu.mooc.app.log.bo;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;

/**
 * LogStudyPos entity. @author MyEclipse Persistence Tools
 */
@Entity
@Table(name = "log_study_pos")
public class LogStudyPos implements java.io.Serializable {

    // Fields

    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private String posId;
    private String logId;
    private Date visitDate;
    private Long visitTime;
    private Integer visitPos;
    private Integer visitDuration;
    /*
    * 行为类型
    * 10：进入
    * 20：暂停
    * 30：快退
    * 40：快进
    * 50：跳出
    * */
    private Integer actionType;

    // Constructors

    /** default constructor */
    public LogStudyPos() {
    }

    /** minimal constructor */
    public LogStudyPos(String posId) {
        this.posId = posId;
    }

    /** full constructor */
    public LogStudyPos(String posId, String logId, Date visitDate,
                       Long visitTime, Integer visitPos, Integer visitDuration,
                       Integer actionType) {
        this.posId = posId;
        this.logId = logId;
        this.visitDate = visitDate;
        this.visitTime = visitTime;
        this.visitPos = visitPos;
        this.visitDuration = visitDuration;
        this.actionType = actionType;
    }

    // Property accessors
    @Id
    @Column(name = "pos_id", unique = true, nullable = false, length = 64)
    public String getPosId() {
        return this.posId;
    }

    public void setPosId(String posId) {
        this.posId = posId;
    }

    @Column(name = "log_id", length = 64)
    public String getLogId() {
        return this.logId;
    }

    public void setLogId(String logId) {
        this.logId = logId;
    }

    @Column(name = "visit_date", length = 19)
    public Date getVisitDate() {
        return this.visitDate;
    }

    public void setVisitDate(Date visitDate) {
        this.visitDate = visitDate;
    }

    @Column(name = "visit_time")
    public Long getVisitTime() {
        return this.visitTime;
    }

    public void setVisitTime(Long visitTime) {
        this.visitTime = visitTime;
    }

    @Column(name = "visit_pos")
    public Integer getVisitPos() {
        return this.visitPos;
    }

    public void setVisitPos(Integer visitPos) {
        this.visitPos = visitPos;
    }

    @Column(name = "visit_duration")
    public Integer getVisitDuration() {
        return this.visitDuration;
    }

    public void setVisitDuration(Integer visitDuration) {
        this.visitDuration = visitDuration;
    }

    @Column(name = "action_type")
    public Integer getActionType() {
        return this.actionType;
    }

    public void setActionType(Integer actionType) {
        this.actionType = actionType;
    }

}