package com.wisedu.mooc.app.home.service.impl;

import java.util.*;

import javax.servlet.http.HttpServletRequest;

import com.wisedu.coeus.core.ConstantStatic;
import com.wisedu.coeus.util.SecurityUtils;
import com.wisedu.coeus.util.json.JSONObject;
import com.wisedu.mooc.app.home.HomeConstantStatic;
import com.wisedu.mooc.app.user.UserConstant;
import com.wisedu.mooc.app.user.dao.UserInfoDao;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.wisedu.coeus.core.bo.LoginUser;
import com.wisedu.coeus.debug.Logger;
import com.wisedu.coeus.debug.LoggerFactory;
import com.wisedu.coeus.util.CookieUtils;
import com.wisedu.coeus.util.Strings;
import com.wisedu.coeus.web.LoginContext;
import com.wisedu.mooc.app.home.service.HomeService;
import com.wisedu.mooc.app.user.bo.UserInfo;

@Service("homeService")
public class HomeServiceImpl implements HomeService {
    /**
     * 日志
     */
    private static Logger log = LoggerFactory.getLogger(HomeServiceImpl.class);

    @Autowired
    UserInfoDao userInfoDao;

    /**
     * 获取用户信息
     */
    @Override
    public UserInfo getUserInfo(Long userId) {
        //return this.userInfoService.queryUser(userId);
        return null;
    }

    /**
     * 执行登陆
     *
     * @param request
     * @param userInfo
     * @return
     */
    public UserInfo executeLogin(HttpServletRequest request, UserInfo userInfo) {
        LoginUser loginUser = new LoginUser(userInfo);
        loginUser.setGuest(false);
        LoginContext.setLoginUser(loginUser);

        LoginContext.saveSession();

        return userInfo;
    }

    /**
     * 获取登陆的UserInfo对象
     *
     * @param loginName
     * @param password
     * @return
     */
    @Override
    public List<UserInfo> getUserInfoForLogin(String loginName, String password) {
        List<UserInfo> userInfos = userInfoDao.queryByLoginNamePwd(loginName, password);
        return userInfos;
    }

    /**
     * 根据登陆名查询用户
     *
     * @param loginName
     * @return
     */
    @Override
    public List<UserInfo> queryUserByLoginName(String loginName) {
        List<UserInfo> userInfos = userInfoDao.queryByLoginName(loginName);
        return userInfos;
    }

    /**
     * 用户注册
     */
    @Override
    public UserInfo insertRegisterInfo(String loginName, String password) {
        UserInfo userInfo = null;
        try {
            String md5Password = SecurityUtils.hashMD5(password).toLowerCase();

            userInfo = new UserInfo();
            userInfo.setLoginName(loginName);
            userInfo.setPassword(md5Password);
            //插入学生角色
            userInfo.setRole(40);
            String useravatar = this.getUserAvatar();
            userInfo.setUseravatar(useravatar);
            userInfo.setDeleteFlag(ConstantStatic.DELETE_FLAG_FALSE);

            this.userInfoDao.insert(userInfo);

        } catch (Exception ex) {
            log.error(ex.getMessage(), ex);
        }

        return userInfo;
    }

    @Override
    public String getUserAvatar() {
        String userPath = ConstantStatic.DEFAULE_USERAVATAR;
        if (!HomeConstantStatic.USERAVATAR_NUM.equals(0)) {
            int num = (int) (Math.random() * HomeConstantStatic.USERAVATAR_NUM) + 1;
            if (num > 0) {
                userPath = HomeConstantStatic.USERAVATAR_PATH + num + "/";
            }
        }
        return userPath;
    }
}
