/*
 * Author: wzan
 *
 * Workfile: ConfigReadyFactoryBean.java
 *
 * Feature NO.: None
 *
 * Copyright (c) 2009 Wiscom. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by Wiscom Ltd.
 *
 */
package com.wisedu.coeus.web;

import javax.servlet.ServletContext;

import org.springframework.beans.factory.InitializingBean;

import com.wisedu.coeus.helper.ApplicationHelper;

/**
 * .
 * <p/>
 * 为jsp等视图准备配置数据,，设置SystemConfig到ServletContext对象中 Author: wzan (wzan@wiscom.com.cn) Date: 2009-12-22 Version: V1.0
 * History:
 */
public final class ConfigReady implements InitializingBean {

    /**
     * afterPropertiesSet
     * 
     * @throws Exception Exception
     */
    public void afterPropertiesSet() throws Exception {
        final ServletContext sc = ApplicationHelper.getServletContext();
        sc.setAttribute("appConfig", AppConfig.getProperties());
        sc.setAttribute("contextPath", sc.getContextPath());

    }

}
