package com.wisedu.coeus.util.sql.impl;

import com.wisedu.coeus.util.Strings;
import com.wisedu.coeus.util.sql.SqlHelper;

/**
 * Mysql的SqlHelper
 */
public class MysqlSqlHelper implements SqlHelper {
    public String supportLike() {
        return " escape '/' ";
    }

    public String formatLikeValue(String value) {
        value = Strings.replace(value, "/", "//");
        value = Strings.replace(value, "%", "/%");
        value = Strings.replace(value, "_", "/_");
        value = Strings.replace(value, "'", "''");

        return value;
    }

    public String toLikeValue(String keyword) {
        StringBuilder like = new StringBuilder(512);
        like.append("%").append(formatLikeValue(keyword)).append("%");
        return like.toString();
    }

    public String toLikeValueStart(String keyword) {
        StringBuilder like = new StringBuilder(512);
        like.append(formatLikeValue(keyword)).append("%");
        return like.toString();
    }

    public String toLikeValueEnd(String keyword) {
        StringBuilder like = new StringBuilder(512);
        like.append("%").append(formatLikeValue(keyword));
        return like.toString();
    }

    public String isNull(String keyword, Object value) {
        StringBuilder isNull = new StringBuilder(512);
        isNull.append("ifnull(").append(keyword).append(",");
        if (value instanceof Integer) {
            isNull.append(value);
        } else if (value instanceof String) {
            isNull.append("'").append(value).append("'");
        }
        isNull.append(") ");
        return isNull.toString();

    }

    public String toDays(String aliasStr) {
        StringBuilder to_days = new StringBuilder(512);
        to_days.append(" to_days(").append(aliasStr).append(") ");
        return to_days.toString();
    }
}
