package com.wisedu.coeus.util.json;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

import com.alibaba.fastjson.JSON;

public class JSONArray implements List<Object> {
    private com.alibaba.fastjson.JSONArray jsonArray;

    public JSONArray(Object object) {


        if (object instanceof String) {
            this.jsonArray = JSON.parseArray((String)object);
        } else {
            Object o = JSON.toJSON(object);
            if (o instanceof com.alibaba.fastjson.JSONArray) {
                this.jsonArray = (com.alibaba.fastjson.JSONArray) o;
            } else {
                List<Object> list = new ArrayList();
                list.add(object);
                this.jsonArray = (com.alibaba.fastjson.JSONArray) JSON.toJSON(list);

            }
        }
    }
    public static JSONArray fromObject(Object javaObject) {
        return new JSONArray(javaObject);
    }

    public JSONObject getJSONObject(int index) {
        return new JSONObject(this.jsonArray.get(index));
    }

    @Override
    public String toString() {
        return JSONObject.toJSONString(this.jsonArray);
    }

    @Override
    public int size() {
        return this.jsonArray.size();
    }

    @Override
    public boolean isEmpty() {
        return this.jsonArray.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.jsonArray.contains(o);
    }

    @Override
    public Iterator iterator() {
        return this.jsonArray.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.jsonArray.toArray();
    }

    @Override
    public boolean add(Object o) {
        return this.jsonArray.add(o);
    }

    @Override
    public boolean remove(Object o) {
        return this.jsonArray.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        return this.jsonArray.containsAll(objects);
    }

    @Override
    public boolean addAll(Collection collection) {
        return this.jsonArray.addAll(collection);
    }

    @Override
    public boolean addAll(int i, Collection collection) {
        return this.jsonArray.addAll(i, collection);
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        return this.jsonArray.removeAll(objects);
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        return this.jsonArray.retainAll(objects);
    }

    @Override
    public void clear() {
        this.jsonArray.clear();
    }

    @Override
    public Object get(int i) {
        return this.jsonArray.get(i);
    }

    @Override
    public Object set(int i, Object o) {
        return this.jsonArray.set(i, o);
    }

    @Override
    public void add(int i, Object o) {
        this.jsonArray.add(i, o);
    }

    @Override
    public Object remove(int i) {
        return this.jsonArray.remove(i);
    }

    @Override
    public int indexOf(Object o) {
        return this.jsonArray.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.jsonArray.lastIndexOf(o);
    }

    @Override
    public ListIterator listIterator() {
        return this.jsonArray.listIterator();
    }

    @Override
    public ListIterator listIterator(int i) {
        return this.jsonArray.listIterator(i);
    }

    @Override
    public List subList(int fromIndex, int toIndex) {
        return this.jsonArray.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray(Object[] objects) {
        return this.jsonArray.toArray(objects);
    }
}
