package com.wisedu.coeus.util;

import com.wisedu.coeus.debug.Logger;
import com.wisedu.coeus.debug.LoggerFactory;
import com.wisedu.coeus.helper.ApplicationHelper;
import com.wisedu.coeus.web.LocaleResolver;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import java.util.Locale;

/**
 * 多语言消息实用工具类
 */
public class MessageUtils {
    protected static Logger LOGGER = LoggerFactory.getLogger(MessageUtils.class);

    /**
     * 获取特定的多语言文本
     * @param messageId                 消息标识
     * @param args                           格式化参数
     * @param defaultMessage        默认消息
     * @param locale                        区域
     * @return
     */
    public static String getMessage(String messageId, Object[] args, String defaultMessage, Locale locale) {
        ApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext(ApplicationHelper.getServletContext());
        if (locale == null) {
            // 获取当前默认的区域设置
            locale = Locale.getDefault();
        }
        return applicationContext.getMessage(messageId, args, defaultMessage, locale);
    }

    /**
     * 获取特定的多语言文本
     * @param messageId 消息标识
     * @return
     */
    public static String getMessage(String messageId) {
        return getMessage(messageId, null, null, LocaleResolver.getLocale());
    }
    
    /**
     * 获取特定的多语言文本
     * @param messageId 消息标识
     * @return
     */
    public static String getMessage(String messageId,Object[] args) {
        return getMessage(messageId, args, null, LocaleResolver.getLocale());
    }
}
