package com.wisedu.coeus.util;

import com.wisedu.coeus.debug.Logger;
import com.wisedu.coeus.debug.LoggerFactory;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.lang.StringUtils;

/**
 * ת
 */
public class DateConverter implements Converter {
    private static Logger LOGGER = LoggerFactory.getLogger(DateConverter.class);

    public Object convert(Class type, Object obj) {
        if(obj==null) return null;

        if(obj instanceof String){
            String value= StringUtils.trimToNull((String) obj);
            if(value==null)  return null;

            try {
                return DateUtils.parseDatetime(value);
            } catch (Exception e) {
                LOGGER.error(e.getMessage(), e);
            }
        }else{
            return null;
        }
        return null;
    }
}
