package com.wisedu.coeus.util;

import com.wisedu.coeus.debug.Logger;
import com.wisedu.coeus.debug.LoggerFactory;
import com.wisedu.coeus.helper.ApplicationHelper;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

/**
 * Created by 01112026 on 14-9-25.
 */
public class CookieUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CookieUtils.class);

    /**
     * 保存Cookie
     *
     * @param response
     * @param key
     * @param value
     * @param expiry
     */
    public static void setCookie(HttpServletResponse response, String key, String value, int expiry) {
        Cookie cookie = new Cookie(key, value);
        String contextPath = ApplicationHelper.getContextPath();
        if (Strings.isEmpty(contextPath)) {
            contextPath = "/";
        }
        if (! contextPath.endsWith("/")) {
            contextPath = contextPath.concat("/");
        }
        if (expiry >= 0) {
            cookie.setMaxAge(expiry);
        }

        cookie.setPath(contextPath);

        response.addCookie(cookie);
    }

    /**
     * 获取Cookie
     *
     * @param request
     * @param key
     * @return
     */
    public static Cookie getCookie(HttpServletRequest request, String key) {
        Cookie[] cookies = request.getCookies();
        if (null == cookies) return null;
        for (Cookie cookie : cookies) {
            if (cookie.getName().equalsIgnoreCase(key)) {
                return cookie;
            }
        }

        return null;
    }

    /**
     * 获取Cookie值
     *
     * @param request
     * @param key
     * @return
     */
    public static String getCookieValue(HttpServletRequest request, String key) {
        if (Strings.isEmpty(key)) {
            return "";
        }

        Cookie cookie = getCookie(request, key);
        if (cookie != null) {
            try {
                return URLDecoder.decode(cookie.getValue(), "utf-8");
            } catch (UnsupportedEncodingException e) {
                LOGGER.error(e.getMessage(), e);
            }
        }
        return "";
    }

    /**
     * 清楚Cookie
     * @param request
     * @param response
     * @param key
     */
    public static void clearCookie(HttpServletRequest request, HttpServletResponse response, String key) {
        Cookie cookie = getCookie(request, key);
        if (cookie!=null){
            setCookie(response, key, "", 0);
        }
    }
}
