package com.wisedu.coeus.debug;

public class Logger {
    private org.slf4j.Logger logger;

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public Logger(org.slf4j.Logger logger) {
        this.logger = logger;
    }

    public void debug(String msg) {
        logger.debug(msg);
    }

    public void debug(String format, Object param1) {
        logger.debug(format, param1);
    }

    public void debug(String format, Object param1, Object param2) {
        logger.debug(format, param1, param2);
    }

    public void debug(String format, Object... argArray) {
        logger.debug(format, argArray);
    }

    public void debug(String msg, Throwable t) {
        logger.debug(msg, t);
    }

    public void error(String msg) {
        logger.error(msg);
    }

    public void error(String format, Object param1) {
        logger.error(format, param1);
    }

    public void error(String format, Object param1, Object param2) {
        logger.error(format, param1, param2);
    }

    public void error(String format, Object... argArray) {
        logger.error(format, argArray);
    }

    public void error(String msg, Throwable t) {
        logger.error(msg, t);
    }

    public void info(String msg) {
        logger.info(msg);
    }

    public void info(String format, Object param1) {
        logger.info(format, param1);
    }

    public void info(String format, Object param1, Object param2) {
        logger.info(format, param1, param2);
    }

    public void info(String format, Object... argArray) {
        logger.info(format, argArray);
    }

    public void info(String msg, Throwable t) {
        logger.info(msg, t);
    }

    public void warn(String msg) {
        logger.info(msg);
    }

    public void warn(String format, Object param1) {
        logger.info(format, param1);
    }

    public void warn(String format, Object param1, Object param2) {
        logger.info(format, param1, param2);
    }

    public void warn(String format, Object... argArray) {
        logger.info(format, argArray);
    }

    public void warn(String msg, Throwable t) {
        logger.info(msg, t);
    }
}
