package com.wisedu.coeus.core.tag;

import com.wisedu.coeus.util.MessageUtils;
import com.wisedu.coeus.util.Strings;
import com.wisedu.coeus.web.LocaleResolver;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import java.io.IOException;

/**
 * Created by 01112026 on 14-8-4.
 */
public class MsgTag extends TagSupport {
    private String code;

    // 参数列表，“,”号分隔
    private String params;

    public void setCode(final String code) {
        this.code = code;
    }

    public void setParams(final String params) {
        this.params = params;
    }


    @Override
    @SuppressWarnings("unchecked")
    public int doEndTag() throws JspException {

        StringBuilder sbHtml = new StringBuilder(1024);

        String[] paramStrArr = null;
        Object[] paramObjArr = null;
        if (Strings.isNotEmpty(params)) {
            paramStrArr = params.split(",");
            paramObjArr = new Object[paramStrArr.length];

            for (int i = 0;i < paramStrArr.length; i++) {
                paramObjArr[i] = paramStrArr[i];
            }
        }

        sbHtml.append(MessageUtils.getMessage(code, paramObjArr, null, LocaleResolver.getLocale()));

        try {
            pageContext.getOut().write(sbHtml.toString());
        }
        catch (IOException e) {

        }
        return EVAL_PAGE;
    }
}
