package com.wisedu.coeus.core.tag;

import com.wisedu.coeus.core.ConstantStatic;
import com.wisedu.coeus.util.Strings;

/**
 * coeus:js 标签
 */
public class JSTag extends StaticResourceTag {

    // style标签中的charset属性
    private String charset;

    public void setCharset(final String charset) {
        this.charset = charset;
    }

    public void setAutoLocale(boolean autoLocale) {
        this.autoLocale = autoLocale;
    }

    public void setSrc(final String href) {
        resourceUrl = href;
    }

    @Override
    protected String getOutputHtml() {
        final StringBuilder sbHtml = new StringBuilder(256);

        sbHtml.setLength(0);
        sbHtml.append("<script src=\"").append(getResourceUrl()).append("\" type=\"text/javascript\"");

        if (Strings.isNotEmpty(charset)) {
            sbHtml.append(" charset=\"").append(charset).append("\"");
        }

        sbHtml.append("></script>");

        return sbHtml.toString();
    }

    @Override
    public void release() {
        resourceUrl = null;
        charset = null;
    }

    private static String basePath;

    @Override
    protected String getBaseUrl() {
        if (basePath != null) {
            return basePath;
        }

        return ConstantStatic.getJsDomain();
    }
}
