package com.wisedu.coeus.core.security;

import java.lang.annotation.*;

/**
 * 授权验证
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface AuthCheck {
    /**
     * 依据权限字符串判断，优先级最低
     * @return
     */
    String[] keys() default {};

    /**
     * 依据角色类型判断，优先级第二
     * @return
     */
    String[] roles() default {};

    /**
     * 依据身份标识判断，优先级最高
     * @return
     */
    String[] identities() default {};

    String limitSite() default "false";
}
