package com.wisedu.coeus.core.db;

import java.util.List;

/**
 * Created by 01112026 on 14-7-28.
 */
public class PageMaker {
    private int pageSize = 20;
    private int pageIndex = 0;
    private long pageCount = 0;
    private long rowCount = 0;

    protected List list = null;

    /**
     * @param pageIndex 开始页码，从1开始
     * @param pageSize  每页多少条记录
     * @param rowCount  总记录条数
     **/
    public PageMaker(int pageIndex, int pageSize, int rowCount) {
        init(pageIndex, pageSize, rowCount);
    }

    public PageMaker(int pageIndex, int pageSize, long rowCount) {
        init(pageIndex, pageSize, rowCount);
    }

    public List getList() {
        return list;
    }

    public void setList(List list) {
        this.list = list;

        if (this.rowCount == 0) {
            this.pageIndex = 0;
            this.pageCount = 0;
            return;
        }

        if (list.size() > 0 && this.pageSize > 0) {
            if (this.rowCount % this.pageSize == 0) {
                this.pageCount = this.rowCount/this.pageSize;
            }
            else {
                this.pageCount = this.rowCount/this.pageSize + 1;
            }
        }
        else {
            this.pageCount = 0;
            this.pageIndex = 0;
        }
    }

    public int getPageSize() {
        return pageSize;
    }

    public int getPageIndex() {
        return pageIndex;
    }


    public long getPageCount() {
        return pageCount;
    }


    public long getRowCount() {
        return rowCount;
    }


    private void init(int pageIndex, int pageSize, long rowCount) {
        this.rowCount = rowCount;
        this.pageSize = pageSize;
        this.pageIndex = pageIndex;

        if (this.pageIndex < 0) {
            this.pageIndex = 1;
        }
        else if ((this.pageIndex-1) * this.pageSize > this.rowCount) {
            this.pageIndex--;
        }
    }
}
