package com.wisedu.coeus.core.cache;

import java.lang.annotation.*;

/**
 * 缓存控制
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface CacheControl {
    /**
     * 缓存的HTTP方法
     * GET和POST
     * @return
     */
    String[] method() default {"GET"};

    /**
     * 缓存过期时长
     * s：秒，30s
     * m：分钟，10m，默认分钟
     * h：小时，1h
     * d：天，1d
     * @return
     */
    String expire() default "30m";
}
