package com.wisedu.coeus.core.bo;

import java.io.Serializable;
import java.util.*;

import com.wisedu.mooc.app.user.bo.UserInfo;


/**
 * 登录用户
 */
public class LoginUser implements Serializable {
    public static final String COEUS_LOGIN_USER_KEY = "moocsk";
    public static final Long COEUS_ANONYMOUS_USER_ID = -1L; // 未登录
    //public static final Long COEUS_LOGOUT_USER_ID = -2L; // 未登录

    private Locale userLocale;
    private UserInfo userInfo;
    private boolean guest;        // 是否是访客
    private String currentSiteUuid;
    private Map<String, Map<String, Set<String>>> roleKeyMap;
    private List<String> identityList = new ArrayList<String>();
    private Map<String, Object> attributes = new HashMap<String, Object>();

    public LoginUser(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public Locale getUserLocale() {
        return userLocale;
    }

    public void setUserLocale(Locale userLocale) {
        this.userLocale = userLocale;
    }

    public UserInfo getUserInfo() {
		return userInfo;
	}

	public void setUserInfo(UserInfo userInfo) {
		this.userInfo = userInfo;
	}

	public boolean getGuest() {
        return guest;
    }

    public void setGuest(boolean guest) {
        this.guest = guest;
    }

    public void setAttribute(String key, Object value) {
        attributes.put(key, value);
    }

    public Object getAttribute(String key) {
        return attributes.get(key);
    }

    public void removeAttribute(String key) {
        attributes.remove(key);
    }

    public String getCurrentSiteUuid() {
        return currentSiteUuid;
    }

    public void setCurrentSiteUuid(String currentSiteUuid) {
        this.currentSiteUuid = currentSiteUuid;
    }

    public Map<String, Map<String, Set<String>>> getRoleKeyMap() {
        return this.roleKeyMap;
    }

    public void setRoleKeyMap(Map<String, Map<String, Set<String>>> roleKeyMap) {
        this.roleKeyMap = roleKeyMap;
    }

    public List<String> getIdentityList() {
        return identityList;
    }

    public void addIdentity(String identity) {
        this.identityList.add(identity);
    }

    public void addIdentity(Integer identity) {
        this.identityList.add(identity.toString());
    }

    public void clearIdentity() {
        this.identityList.clear();
    }

}
