package com.wisedu.coeus.core;

import java.util.Locale;

import org.apache.commons.lang.StringUtils;

import com.wisedu.coeus.helper.ApplicationHelper;
import com.wisedu.coeus.util.Strings;
import com.wisedu.coeus.web.AppConfig;

public final class ConstantStatic {

	/** 常量定义 */
	public static final Integer INT_0 = 0;
	public static final Integer INT_1 = 1;
	public static final Integer INT_2 = 2;

	public static final Integer DELETE_FLAG_FALSE = 0;

    /** 临时文件目录 **/
	public static final String  TEMP_FILE_PATH = "temp";

    /** 默认语言 */
    public static final Locale DEFAULT_LOCALE = Locale.CHINA;

    /** 网址地址前缀 **/
	public static final String RESOURCE_DOMAIN = Strings.isEmpty(AppConfig.getProperty("curSite.url"))?ApplicationHelper.getContextPath():AppConfig.getProperty("curSite.url");

	 /** 本地资源存储根目录的物理路径 */
	public static final String RESOURCE_PATH = ApplicationHelper.getWebRootPath();

	public static final String SPECIAL_BLANK="[\\s　]";

    // 看视频算结束的剩余时间
	public static final Long STUDY_OVER_DEFAULT_TIME = 60000L;

	 /** The Constant HTTP_JSON_CONTENTTYPE. */
    public static final String HTTP_JSON_CONTENTTYPE = "application/json;charset=UTF-8";

	public static final int DEFAULT_PAGE10 = 10; //默认一页10条记录

	public static final String DEFAULE_USERAVATAR = "/images/avatar/default/";

    //CDN发布
    public static final String UPLOAD_RESOURCE_TYPE = AppConfig.getProperty("upload.resource.type","local");  //云端视频上传方式
    public static final String UPLOAD_RESOURCE_TYPE_ALIYUN = "aliyun";      //上传到阿里云
    public static final String UPLOAD_RESOURCE_TYPE_LOCAL = "local";        //上传到本地

    public static final String STATIC_PATH_IMG = AppConfig.getProperty("coeus.static.path.img");
    public static final String STATIC_PATH_CSS = AppConfig.getProperty("coeus.static.path.css");
    public static final String STATIC_PATH_JS = "";

    public static final String PAGE_TITLE = "pageTitle";
    public static final String PAGE_KEYWORDS = "pageKeywords";
    public static final String PAGE_DESCRIPTION = "pageDescription";

    /**视频资源访问Url前缀 **/
    public static final String RESOURCE_URL_PREFIX = AppConfig.getProperty("resource.url.prefix");

    /**视频上传后，调用云监控数据上报的配置属性 2016-05-03 **/
    public static  boolean MONITOR_FLAG = "true".equalsIgnoreCase(AppConfig.getProperty("use.monitor"));
    public static  String MONITOR_URL = AppConfig.getProperty("monitor.url");
    public static  String MONITOR_USERID = AppConfig.getProperty("monitor.userId");
    public static  String MONITOR_NAMESPACE = AppConfig.getProperty("monitor.namespace");
    public static String MONITOR_METRICNAME = AppConfig.getProperty("metric.name");
    public static String MONITOR_UNIT = AppConfig.getProperty("unit");
    public static String MONITOR_DIMENSION_KEY = AppConfig.getProperty("monitor.dimension.key");
    public static String MONITOR_DIMENSION_VALUE = AppConfig.getProperty("monitor.dimension.value");


    /**
     * 获取资源访问url
     * @return
     */
    public static String getResourceDomain() {
        
        return ConstantStatic.RESOURCE_DOMAIN;
        
    }
    
    /**
     * 获取视频资源访问url
     * @return
     */
    public static String getResourceDomainUrl() {
        
    	String url = ConstantStatic.RESOURCE_URL_PREFIX;
    	
    	if(Strings.isEmpty(url)){
    		url = ConstantStatic.RESOURCE_DOMAIN;
    	}
    	
        return url;
    }

    public static String getImgDomain() {
        if (Strings.isEmpty(ConstantStatic.STATIC_PATH_IMG)) return "";
        return ConstantStatic.STATIC_PATH_IMG;
    }

    public static String getCssDomain() {
        if (Strings.isEmpty(ConstantStatic.STATIC_PATH_CSS)) return "";
        return ConstantStatic.STATIC_PATH_CSS;
    }

    public static String getJsDomain() {
        if (Strings.isEmpty(ConstantStatic.STATIC_PATH_JS)) return "";

        return ConstantStatic.STATIC_PATH_JS;
    }

}
