/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render.output.javafx;

import java.awt.BasicStroke;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PdfPageData;
import org.jpedal.render.ShapeFactory;
import org.jpedal.render.output.OutputDisplay;
import org.jpedal.render.output.OutputShape;

public class FXMLShape
extends OutputShape
implements ShapeFactory {
    private GraphicsState gs;
    private int windingRule = 1;

    public FXMLShape(int n, int n2, float f, Shape shape, GraphicsState graphicsState, AffineTransform affineTransform, Point2D point2D, Rectangle rectangle, int n3, int n4, int n5, PdfPageData pdfPageData, int n6, boolean bl) {
        super(n, f, shape, graphicsState, affineTransform, point2D, rectangle, n3, n4, n5, pdfPageData, n6, bl);
        this.shapeCount = n2;
        this.gs = graphicsState;
        this.windingRule = shape.getPathIterator(affineTransform).getWindingRule();
        this.generateShapeFromG2Data(graphicsState, affineTransform, rectangle);
    }

    public void checkShapeClosed() {
        if (this.shapeIsOpen) {
            this.shapeIsOpen = false;
            this.finishShape();
        }
    }

    protected void beginShape() {
        Object object;
        float f;
        Object object2;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        int n = this.gs.getFillType();
        if (n == 2 || n == 3) {
            object2 = this.gs.getNonstrokeColor();
            if (this.windingRule == 0) {
                string7 = " fillRule=\"even_odd\"";
            }
            if ((f = this.gs.getAlpha(2)) != 1.0f) {
                string8 = " opacity=\"" + f + "\"";
            }
            object = OutputDisplay.hexColor(object2.getRGB());
            string4 = " stroke=\"TRANSPARENT\"";
            string6 = " fill=\"" + (String)object + '\"';
            this.currentColor = object2.getRGB();
        }
        if (n == 1 || n == 3) {
            object2 = (BasicStroke)this.gs.getStroke();
            f = this.gs.getAlpha(1);
            if (f != 1.0f) {
                string8 = " opacity=\"" + f + "\"";
            }
            if (this.gs.getOutputLineWidth() != 1) {
                string = " strokeWidth=\"" + this.gs.getOutputLineWidth() + '\"';
            }
            if (((BasicStroke)object2).getMiterLimit() != 10.0f) {
                string5 = " strokeMiterLimit=\"" + this.gs.getOutputLineWidth() + '\"';
            }
            string2 = " strokeLineCap=\"" + FXMLShape.determineLineCap((BasicStroke)object2) + '\"';
            string3 = " strokeLineJoin=\"" + FXMLShape.determineLineJoin((BasicStroke)object2) + '\"';
            object = this.gs.getStrokeColor();
            String string9 = OutputDisplay.hexColor(object.getRGB());
            string4 = " stroke=\"" + string9 + '\"';
        }
        this.pathCommands.add("\t");
        this.pathCommands.add("<Path id=\"path" + this.shapeCount + '\"' + string7 + string4 + string6 + string + string2 + string3 + string5 + string8 + '>');
        this.pathCommands.add("\t<elements>");
    }

    protected void finishShape() {
        this.pathCommands.add("\t</elements>");
        this.pathCommands.add("</Path>");
    }

    protected void lineTo(double[] dArray) {
        String string = this.coordsToStringParam(dArray, 2);
        String string2 = ",";
        String[] stringArray = string.split(string2);
        this.pathCommands.add("\t\t<LineTo x=\"" + stringArray[0] + "\" y=\"" + stringArray[1] + "\"/>");
    }

    protected void bezierCurveTo(double[] dArray) {
        String string = this.coordsToStringParam(dArray, 6);
        String string2 = ",";
        String[] stringArray = string.split(string2);
        this.pathCommands.add("\t\t<CubicCurveTo controlX1=\"" + stringArray[0] + "\" controlY1=\"" + stringArray[1] + "\" controlX2=\"" + stringArray[2] + "\" controlY2=\"" + stringArray[3] + "\" x=\"" + stringArray[4] + "\" y=\"" + stringArray[5] + "\" />");
    }

    protected void quadraticCurveTo(double[] dArray) {
        String string = this.coordsToStringParam(dArray, 4);
        String string2 = ",";
        String[] stringArray = string.split(string2);
        this.pathCommands.add("\t\t<QuadCurveTo controlX=\"" + stringArray[0] + "\" controlY=\"" + stringArray[1] + "\" x=\"" + stringArray[2] + "\" y=\"" + stringArray[3] + "\" />");
    }

    protected void moveTo(double[] dArray) {
        String string = this.coordsToStringParam(dArray, 2);
        String string2 = ",";
        String[] stringArray = string.split(string2);
        this.pathCommands.add("\t\t<MoveTo x=\"" + stringArray[0] + "\" y=\"" + stringArray[1] + "\"/>");
    }

    protected void closePath() {
        this.pathCommands.add("\t\t<ClosePath />");
    }

    protected void drawCropBox() {
        double[] dArray = new double[]{this.cropBox.x, this.cropBox.y};
        this.pathCommands.add("\t\t<MoveTo x=\"" + dArray[0] + "\" y=\"" + dArray[1] + "\"/>");
        dArray[0] = dArray[0] + (double)this.cropBox.width;
        this.pathCommands.add("\t\t<LineTo x=\"" + dArray[0] + "\" y=\"" + dArray[1] + "\"/>");
        dArray[1] = dArray[1] + (double)this.cropBox.height;
        this.pathCommands.add("\t\t<LineTo x=\"" + dArray[0] + "\" y=\"" + dArray[1] + "\"/>");
        dArray[0] = dArray[0] - (double)this.cropBox.width;
        this.pathCommands.add("\t\t<LineTo x=\"" + dArray[0] + "\" y=\"" + dArray[1] + "\"/>");
    }

    protected void applyGraphicsStateToPath(GraphicsState graphicsState) {
    }

    protected static String determineLineCap(BasicStroke basicStroke) {
        String string;
        switch (basicStroke.getEndCap()) {
            case 1: {
                string = "ROUND";
                break;
            }
            case 2: {
                string = "SQUARE";
                break;
            }
            default: {
                string = "BUTT";
            }
        }
        return string;
    }

    protected static String determineLineJoin(BasicStroke basicStroke) {
        String string;
        switch (basicStroke.getLineJoin()) {
            case 1: {
                string = "ROUND";
                break;
            }
            case 2: {
                string = "BEVEL";
                break;
            }
            default: {
                string = "MITER";
            }
        }
        return string;
    }

    public void setShapeNumber(int n) {
        this.shapeCount = n;
    }
}

