/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.formData;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;
import org.jpedal.external.CustomFormPrint;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.acroforms.creation.FormFactory;
import org.jpedal.objects.acroforms.creation.JPedalBorderFactory;
import org.jpedal.objects.acroforms.formData.ComponentData;
import org.jpedal.objects.acroforms.overridingImplementations.FixImageIcon;
import org.jpedal.objects.acroforms.overridingImplementations.PdfSwingPopup;
import org.jpedal.objects.acroforms.overridingImplementations.ReadOnlyTextIcon;
import org.jpedal.objects.acroforms.utils.FormUtils;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class SwingData
extends ComponentData {
    public static boolean JVMBugRightAlignFix = false;
    CustomFormPrint customFormPrint = null;
    private JPanel panel;
    public static int readOnlyScaling = -1;
    boolean renderFormsWithJPedalFontRenderer = false;
    private Component[] popups = new Component[0];
    int maxLengthForTextOnPage = 0;

    public SwingData() {
    }

    public SwingData(int n) {
        this.formFactoryType = n;
    }

    public void loseFocus() {
    }

    public void setValue(String string, Object object, boolean bl, boolean bl2) {
        Object object2 = super.setValue(string, object, bl, bl2, this.getValue(string));
        if (object2 != null) {
            this.setFormValue(object, object2);
        }
    }

    public Object getFormValue(Object object) {
        Object object2 = "";
        if (object != null) {
            int n = (Integer)object;
            Object object3 = this.checkGUIObjectResolved((Integer)object);
            FormObject formObject = (FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(n));
            int n2 = formObject.getFormType();
            switch (n2) {
                case 9: {
                    object2 = ((JCheckBox)object3).isSelected();
                    break;
                }
                case 2: {
                    object2 = ((JComboBox)object3).getSelectedItem();
                    break;
                }
                case 1: {
                    object2 = ((JList)object3).getSelectedValues();
                    break;
                }
                case 8: {
                    object2 = ((JRadioButton)object3).isSelected();
                    break;
                }
                case 4: {
                    object2 = ((JTextComponent)object3).getText();
                    break;
                }
                case 6: {
                    object2 = ((JTextComponent)object3).getText();
                    break;
                }
                case 5: {
                    object2 = ((JTextComponent)object3).getText();
                    break;
                }
                case 3: {
                    if (object3 instanceof JButton) {
                        object2 = ((ReadOnlyTextIcon)((JButton)object3).getIcon()).getText();
                        break;
                    }
                    object2 = formObject.getTextString();
                    break;
                }
                default: {
                    switch (formObject.getGUIType()) {
                        case 0: {
                            object2 = formObject.getTextString();
                        }
                    }
                }
            }
        }
        return object2;
    }

    public void setFormValue(Object object, Object object2) {
        if (object2 != null) {
            int n = (Integer)object2;
            Component component = (Component)this.checkGUIObjectResolved(n);
            FormObject formObject = (FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(n));
            int n2 = formObject.getFormType();
            switch (n2) {
                case 9: {
                    ((JCheckBox)component).setSelected(Boolean.valueOf((String)object));
                    break;
                }
                case 2: {
                    ((JComboBox)component).setSelectedItem(object);
                    break;
                }
                case 1: {
                    ((JList)component).setSelectedValue(object, false);
                    break;
                }
                case 8: {
                    ((JRadioButton)component).setText((String)object);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    ((JTextComponent)component).setText((String)object);
                    break;
                }
                case 3: {
                    this.checkGUIObjectResolved(n);
                    if (component instanceof JButton) {
                        ((ReadOnlyTextIcon)((JButton)component).getIcon()).setText((String)object);
                        break;
                    }
                    ((JTextComponent)component).setText((String)object);
                    break;
                }
                case 7: 
                case 10: 
                case 11: {
                    break;
                }
            }
        }
    }

    public void debugForms() {
    }

    public void showForms() {
        if (this.nextFreeField > 0) {
            for (int i = 0; i < this.nextFreeField + 1; ++i) {
                FormObject formObject = (FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(i));
                if (formObject == null) continue;
                Component component = (Component)this.checkGUIObjectResolved(i);
                int n = formObject.getFormType();
                if (component == null) continue;
                if (n == 7 || n == 10 || n == 11) {
                    component.setBackground(Color.blue);
                } else if (n == 4 || n == 3 || n == 5 || n == 6) {
                    component.setBackground(Color.red);
                    if (component instanceof JButton) {
                        component.setBackground(Color.cyan);
                    }
                } else {
                    component.setBackground(Color.green);
                }
                component.setForeground(Color.lightGray);
                component.setVisible(true);
                component.setEnabled(true);
                ((JComponent)component).setOpaque(true);
                if (n == 7 || n == 9 || n == 10 || n == 11) {
                    ((AbstractButton)component).setIcon(null);
                    continue;
                }
                if (n != 2) continue;
                ((JComboBox)component).setEditable(false);
            }
        }
    }

    private void renderComponent(Graphics2D graphics2D, int n, Component component, int n2, boolean bl, int n3, boolean bl2) {
        if (component != null) {
            JTextField jTextField;
            Object object;
            Serializable serializable;
            boolean bl3 = false;
            int n4 = this.getPageForFormObject(this.convertIDtoRef(n));
            if (!bl && component instanceof JComboBox) {
                serializable = (JComboBox)component;
                if (((JComboBox)serializable).isEditable()) {
                    bl3 = true;
                    ((JComboBox)serializable).setEditable(false);
                }
                if (((Container)serializable).getComponentCount() > 0 && (object = ((JComboBox)serializable).getSelectedItem()) != null) {
                    jTextField = new JTextField();
                    jTextField.setText(object.toString());
                    jTextField.setBackground(((Component)serializable).getBackground());
                    jTextField.setForeground(((Component)serializable).getForeground());
                    jTextField.setFont(((Component)serializable).getFont());
                    jTextField.setBorder(((JComponent)serializable).getBorder());
                    this.renderComponent(graphics2D, n, jTextField, n2, false, n3, bl2);
                }
                bl = true;
            }
            if (!bl) {
                Serializable serializable2;
                serializable = graphics2D.getTransform();
                if (bl2) {
                    this.scaleComponent(n4, 1.0f, n2, n, component, false, false, n3);
                    switch (360 - n2) {
                        case 270: {
                            object = AffineTransform.getRotateInstance(4.71238898038469, 0.0, 0.0);
                            graphics2D.translate(component.getBounds().y + this.cropOtherY[n4] - this.insetH, this.pageData.getCropBoxHeight(n4) - component.getBounds().x + this.insetW);
                            graphics2D.transform((AffineTransform)object);
                            graphics2D.translate(-this.insetW, 0);
                            break;
                        }
                        case 90: {
                            object = AffineTransform.getRotateInstance(1.5707963267948966, 0.0, 0.0);
                            graphics2D.translate(component.getBounds().y + this.cropOtherY[n4] - this.insetH, component.getBounds().x + this.insetW);
                            graphics2D.transform((AffineTransform)object);
                            graphics2D.translate(0, -this.insetH);
                            break;
                        }
                        case 180: {
                            object = AffineTransform.getRotateInstance(Math.PI, 0.0, 0.0);
                            graphics2D.translate(component.getBounds().x - this.insetW, component.getBounds().y + this.cropOtherY[n4]);
                            graphics2D.transform((AffineTransform)object);
                            graphics2D.translate(-this.insetW, -this.insetH);
                            break;
                        }
                        default: {
                            graphics2D.translate(component.getBounds().x - this.insetW, component.getBounds().y + this.cropOtherY[n4]);
                            break;
                        }
                    }
                } else {
                    this.scaleComponent(n4, 1.0f, n2, n, component, false, false, n3);
                    object = component.getBounds();
                    graphics2D.translate(((Rectangle)object).x - this.insetW, ((Rectangle)object).y + this.cropOtherY[n4]);
                    if (this.getFieldType(component) == 0) {
                        int n5;
                        if (this.pageData.getRotation(n4) == 90 || this.pageData.getRotation(n4) == 270) {
                            component.setBounds(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).height, ((Rectangle)object).width);
                            object = component.getBounds();
                        }
                        if ((n5 = n2 - this.pageData.getRotation(0)) < 0) {
                            n5 = 360 + n5;
                        }
                        switch (n5) {
                            case 270: {
                                serializable2 = AffineTransform.getRotateInstance((double)n5 * Math.PI / 180.0, 0.0, 0.0);
                                graphics2D.transform((AffineTransform)serializable2);
                                graphics2D.translate(-((Rectangle)object).width, 0);
                                break;
                            }
                            case 90: {
                                serializable2 = AffineTransform.getRotateInstance((double)n5 * Math.PI / 180.0, 0.0, 0.0);
                                graphics2D.transform((AffineTransform)serializable2);
                                graphics2D.translate(0, -((Rectangle)object).height);
                                break;
                            }
                            case 180: {
                                serializable2 = AffineTransform.getRotateInstance((double)n5 * Math.PI / 180.0, 0.0, 0.0);
                                graphics2D.transform((AffineTransform)serializable2);
                                graphics2D.translate(-((Rectangle)object).width, -((Rectangle)object).height);
                            }
                        }
                    }
                }
                boolean bl4 = false;
                if (JVMBugRightAlignFix && component instanceof JTextField) {
                    jTextField = new JTextField();
                    serializable2 = (JTextField)component;
                    if (((JTextField)serializable2).getHorizontalAlignment() == 4) {
                        String string;
                        jTextField.setFont(((Component)serializable2).getFont());
                        jTextField.setLocation(((Component)serializable2).getLocation());
                        jTextField.setSize(((Component)serializable2).getSize());
                        jTextField.setBorder(((JComponent)serializable2).getBorder());
                        jTextField.setHorizontalAlignment(4);
                        int n6 = 0;
                        int n7 = graphics2D.getFontMetrics(component.getFont()).stringWidth(new String(SwingData.createCharArray(' ', this.maxLengthForTextOnPage - ((JTextComponent)serializable2).getText().length())) + ((JTextComponent)serializable2).getText());
                        int n8 = graphics2D.getFontMetrics(component.getFont().deriveFont(7.0f)).stringWidth(new String(SwingData.createCharArray(' ', this.maxLengthForTextOnPage - ((JTextComponent)serializable2).getText().length())) + ((JTextComponent)serializable2).getText());
                        int n9 = n7 - n8;
                        if (n9 > 0) {
                            n6 = n9 / graphics2D.getFontMetrics(component.getFont().deriveFont(7.0f)).stringWidth(" ");
                        }
                        String string2 = ((JTextComponent)serializable2).getText();
                        int n10 = this.maxLengthForTextOnPage + n6 - ((JTextComponent)serializable2).getText().length();
                        jTextField.setText(new String(SwingData.createCharArray(' ', n10)) + string2);
                        n7 = graphics2D.getFontMetrics(component.getFont()).stringWidth(jTextField.getText());
                        int n11 = 0;
                        if (jTextField.getBorder() != null) {
                            n11 = jTextField.getBorder().getBorderInsets((Component)jTextField).left + jTextField.getBorder().getBorderInsets((Component)jTextField).right;
                        }
                        boolean bl5 = false;
                        while (n10 > 0 && n7 > jTextField.getWidth() - n11) {
                            n10 = this.maxLengthForTextOnPage + n6 - ((JTextComponent)serializable2).getText().length();
                            string = new String(SwingData.createCharArray(' ', n10)) + string2;
                            jTextField.setText(string);
                            --n6;
                            n7 = graphics2D.getFontMetrics(component.getFont().deriveFont(7.0f)).stringWidth(jTextField.getText());
                            bl5 = true;
                        }
                        if (bl5) {
                            n10 = this.maxLengthForTextOnPage + --n6 - ((JTextComponent)serializable2).getText().length();
                            string = new String(SwingData.createCharArray(' ', n10)) + string2;
                            jTextField.setText(string);
                        }
                        jTextField.paint(graphics2D);
                        bl4 = true;
                    }
                }
                if (!bl4) {
                    component.paint(graphics2D);
                }
                graphics2D.setTransform((AffineTransform)serializable);
            }
            if (bl3) {
                ((JComboBox)component).setEditable(true);
            }
        }
    }

    private static char[] createCharArray(char c, int n) {
        if (n <= 0) {
            return new char[0];
        }
        char[] cArray = new char[n];
        Arrays.fill(cArray, 0, cArray.length, c);
        return cArray;
    }

    public void renderFormsOntoG2(Object object, int n, float f, int n2, int n3, Map map, FormFactory formFactory, PdfObjectReader pdfObjectReader, int n4) {
        Graphics2D graphics2D;
        AffineTransform affineTransform3;
        block29: {
            Component component;
            Component component2;
            int n5;
            AffineTransform affineTransform2;
            boolean bl;
            if (this.formsUnordered == null || this.rasterizeForms) {
                return;
            }
            this.componentsToIgnore = map;
            boolean bl2 = bl = formFactory != null;
            if (JVMBugRightAlignFix && bl) {
                this.maxLengthForTextOnPage = 0;
                for (AffineTransform affineTransform3 : this.formsUnordered[n]) {
                    int n6;
                    affineTransform2 = affineTransform3;
                    n5 = (Integer)this.refToCompIndex.get(affineTransform2);
                    if (n5 == -1 || !((component2 = (Component)this.checkGUIObjectResolved(n5)) instanceof JTextField) || (n6 = ((JTextComponent)(component = (JTextField)component2)).getText().length()) <= this.maxLengthForTextOnPage || ((JTextField)component).getHorizontalAlignment() != 4) continue;
                    this.maxLengthForTextOnPage = n6;
                }
            }
            graphics2D = (Graphics2D)object;
            affineTransform3 = graphics2D.getTransform();
            affineTransform2 = graphics2D.getTransform();
            affineTransform2.scale(1.0, -1.0);
            affineTransform2.translate(0.0, -n4 - this.insetH);
            graphics2D.setTransform(affineTransform2);
            try {
                JPanel jPanel = new JPanel();
                for (Object e : this.formsUnordered[n]) {
                    boolean[] blArray;
                    component2 = this.refToCompIndex.get(e);
                    if (component2 == null || (n5 = ((Integer)((Object)component2)).intValue()) == -1 || (blArray = ((FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(n5))).getCharacteristics())[1] || bl && !blArray[2]) continue;
                    this.checkGUIObjectResolved(n5);
                    FormObject formObject = (FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(n5));
                    component = (Component)formObject.getGUIComponent();
                    if (component != null && component.isVisible()) {
                        Object object2;
                        Object object3;
                        this.syncKidValues(n5);
                        Rectangle rectangle = formObject.getBoundingRectangle();
                        float f2 = rectangle.height;
                        int n7 = component.getPreferredSize().height + 6;
                        if (this.renderFormsWithJPedalFontRenderer) {
                            object3 = this.convertIDtoRef(n5);
                            object2 = this.getRawForm((String)object3);
                            for (Object object4 : object2) {
                                if (object4 == null) continue;
                                FormObject formObject2 = (FormObject)object4;
                                System.out.println((String)object3 + ' ' + formObject2.getTextFont() + ' ' + formObject2.getTextString());
                            }
                        } else if (!this.isFormNotPrinted(n5)) {
                            if (component instanceof JList && ((JList)component).getSelectedIndex() != -1 && f2 < (float)n7) {
                                object3 = (JList)component;
                                jPanel.add(component);
                                object2 = ((JList)object3).getModel();
                                Object[] objectArray = new Object[object2.getSize()];
                                int n8 = ((JList)object3).getSelectedIndex();
                                int n9 = 0;
                                objectArray[n9++] = object2.getElementAt(n8);
                                for (int i = 0; i < objectArray.length; ++i) {
                                    if (i == n8) continue;
                                    objectArray[n9++] = object2.getElementAt(i);
                                }
                                ((JList)object3).setListData(objectArray);
                                ((JList)object3).setSelectedIndex(0);
                                try {
                                    this.renderComponent(graphics2D, n5, (Component)object3, n3, false, n2, bl);
                                    jPanel.remove((Component)object3);
                                }
                                catch (Exception exception) {}
                            } else {
                                boolean bl3 = false;
                                if (this.customFormPrint != null) {
                                    this.scaleComponent(this.currentPage, 1.0f, this.rotation, n5, component, false, false, this.indent);
                                    bl3 = this.customFormPrint.print(graphics2D, n5, component, this);
                                }
                                if (!bl3) {
                                    if (component instanceof AbstractButton && (object2 = ((AbstractButton)component).getIcon()) != null) {
                                        if (object2 instanceof FixImageIcon) {
                                            ((FixImageIcon)object2).setPrinting(true, 1);
                                        } else if (readOnlyScaling > 0 && object2 instanceof ReadOnlyTextIcon) {
                                            ((ReadOnlyTextIcon)object2).setPrinting(true, readOnlyScaling);
                                        }
                                    }
                                    jPanel.add(component);
                                    try {
                                        this.renderComponent(graphics2D, n5, component, n3, false, n2, bl);
                                        jPanel.remove(component);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    if (component instanceof AbstractButton) {
                                        object2 = ((AbstractButton)component).getIcon();
                                        if (object2 instanceof FixImageIcon) {
                                            ((FixImageIcon)object2).setPrinting(false, 1);
                                        } else if (object2 instanceof ReadOnlyTextIcon) {
                                            ((ReadOnlyTextIcon)object2).setPrinting(false, 1);
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (++n5 != this.nextFreeField + 1) continue;
                    break;
                }
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block29;
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
        }
        graphics2D.setTransform(affineTransform3);
        if (this.currentPage == n && this.panel != null) {
            this.resetScaledLocation(this.displayScaling, this.rotation, this.indent);
        }
    }

    private void scaleComponent(int n, float f, int n2, int n3, Component component, boolean bl, boolean bl2, int n4) {
        Serializable serializable;
        FormObject formObject;
        int n5;
        Object object;
        Object object2;
        if (component == null) {
            return;
        }
        if (this.layers != null) {
            object2 = this.convertIDtoRef(n3);
            String string = null;
            object = this.getRawForm((String)object2);
            if (object[0] != null) {
                string = ((FormObject)object[0]).getLayerName();
            }
            if (string != null && this.layers.isLayerName(string)) {
                n5 = this.layers.isVisible(string);
                component.setVisible(n5 != 0);
            }
        }
        object2 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        boolean bl3 = true;
        if (bl2) {
            object = component.getBounds();
            if (object.x != 0 && object.y != 0) {
                bl3 = false;
            } else {
                object2 = this.popupBounds[n3];
            }
        } else {
            object = (FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(n3));
            Rectangle rectangle = object.getBoundingRectangle();
            object2 = new float[]{rectangle.x, rectangle.y, rectangle.width + rectangle.x, rectangle.height + rectangle.y};
        }
        object = new int[]{0, 0, 0, 0};
        if (bl3) {
            n5 = n2;
            object = this.cropComponent((float[])object2, n, f, n5, n3, bl);
        }
        if (bl2) {
            object[2] = (int)(this.popupBounds[n3][2] - this.popupBounds[n3][0]);
            object[3] = (int)(this.popupBounds[n3][3] - this.popupBounds[n3][1]);
        }
        Font font = component.getFont();
        if (!bl2 && font != null) {
            this.recalcFontSize(f, n2, n3, component);
        }
        if (!bl2 && component instanceof JComponent && ((JComponent)component).getBorder() != null && (formObject = (FormObject)this.rawFormData.get(this.convertIDtoRef(n3))) != null) {
            ((JComponent)component).setBorder((Border)this.generateBorderfromForm(formObject, f));
        }
        if (bl3 && this.xReached != null) {
            object[0] = object[0] + this.xReached[n];
            object[1] = object[1] + this.yReached[n];
        }
        int n6 = (this.pageData.getRotation(n) + n2) % 180 == 90 ? this.pageData.getCropBoxHeight(n) : this.pageData.getCropBoxWidth(n);
        if (this.displayView == 2) {
            double d = n2 == 0 || n2 == 180 ? (double)((this.widestPageNR - n6) / 2) : (double)((this.widestPageR - n6) / 2);
            n4 = (int)((double)n4 + d * (double)f);
        }
        int n7 = this.userX + n4 + this.insetW;
        int n8 = this.userY + this.insetH;
        Rectangle rectangle = new Rectangle(n7 + object[0], n8 + object[1], (int)object[2], (int)object[3]);
        if (bl2) {
            if (!bl3) {
                serializable = component.getBounds();
                rectangle.x = ((Rectangle)serializable).x;
                rectangle.y = ((Rectangle)serializable).y;
            }
            SwingData.checkPopupBoundsOnPage(rectangle, this.panel.getVisibleRect());
        }
        component.setBounds(rectangle);
        if (component != null && component instanceof AbstractButton) {
            serializable = (AbstractButton)component;
            Icon icon = ((AbstractButton)serializable).getIcon();
            boolean bl4 = false;
            if (this.displayView == 1 || this.displayView == 0) {
                bl4 = true;
            }
            int n9 = n2;
            if (icon instanceof FixImageIcon) {
                ((FixImageIcon)icon).setAttributes(component.getWidth(), component.getHeight(), n9, bl4);
            } else if (icon instanceof ReadOnlyTextIcon) {
                ((ReadOnlyTextIcon)icon).setAttributes(component.getWidth(), component.getHeight(), n9, bl4);
            }
            icon = ((AbstractButton)serializable).getPressedIcon();
            if (icon instanceof FixImageIcon) {
                ((FixImageIcon)icon).setAttributes(component.getWidth(), component.getHeight(), n9, bl4);
            }
            if ((icon = ((AbstractButton)serializable).getSelectedIcon()) instanceof FixImageIcon) {
                ((FixImageIcon)icon).setAttributes(component.getWidth(), component.getHeight(), n9, bl4);
            }
            if ((icon = ((AbstractButton)serializable).getRolloverIcon()) instanceof FixImageIcon) {
                ((FixImageIcon)icon).setAttributes(component.getWidth(), component.getHeight(), n9, bl4);
            }
            if ((icon = ((AbstractButton)serializable).getRolloverSelectedIcon()) instanceof FixImageIcon) {
                ((FixImageIcon)icon).setAttributes(component.getWidth(), component.getHeight(), n9, bl4);
            }
        }
    }

    private void recalcFontSize(float f, int n, int n2, Component component) {
        int n3;
        FormObject formObject = (FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(n2));
        int n4 = formObject.getTextSize();
        if (n4 == -1) {
            n4 = 0;
        }
        if (n4 == 0) {
            int n5;
            Rectangle rectangle = formObject.getBoundingRectangle();
            int n6 = rectangle.width;
            int n7 = rectangle.height;
            if (n == 90 || n == 270) {
                n5 = n7;
                n7 = n6;
                n6 = n5;
            }
            n4 = (int)((double)n7 * 0.85);
            if (component instanceof JTextArea) {
                String string = ((JTextArea)component).getText();
                n4 = SwingData.calculateFontSize(n7, n6, true, string);
            } else if (component instanceof JTextField) {
                String string = ((JTextComponent)component).getText();
                n4 = SwingData.calculateFontSize(n7, n6, false, string);
            } else if (component instanceof JButton) {
                String string = ((JButton)component).getText();
                if (string != null) {
                    n4 = SwingData.calculateFontSize(n7, n6, false, string);
                }
            } else if (component instanceof JList) {
                n5 = ((JList)component).getModel().getSize() + 2;
                n4 /= n5;
            }
        }
        if ((n3 = (int)((float)n4 * f)) < 1) {
            n3 = 1;
        }
        Font font = component.getFont();
        Font font2 = new Font(font.getFontName(), font.getStyle(), n3);
        component.setFont(font2);
    }

    public Object generateBorderfromForm(FormObject formObject, float f) {
        float[] fArray = formObject.getDictionary(7451).getFloatArray(4627);
        if (fArray == null && formObject.getParameterConstant(1147962727) == 1110792305) {
            fArray = formObject.getFloatArray(19);
        }
        Border border = JPedalBorderFactory.createBorderStyle(formObject.getDictionary(4643), FormObject.generateColor(fArray), Color.white, f);
        return border;
    }

    private int[] cropComponent(float[] fArray, int n, float f, int n2, int n3, boolean bl) {
        if (this.displayView != 1 && this.displayView != 0) {
            n2 = (n2 + this.pageData.getRotation(n)) % 360;
        }
        int n4 = this.pageData.getCropBoxX(n);
        int n5 = this.pageData.getCropBoxY(n);
        int n6 = this.pageData.getCropBoxWidth(n);
        int n7 = this.pageData.getMediaBoxWidth(n);
        int n8 = this.pageData.getMediaBoxHeight(n);
        int n9 = n7 - n6 - n4;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        switch (n2) {
            case 0: {
                float f2 = fArray[0];
                if (bl) {
                    f2 -= (float)n4;
                }
                float f3 = (float)n8 - fArray[3] - (float)this.cropOtherY[n];
                float f4 = fArray[2] - fArray[0];
                float f5 = fArray[3] - fArray[1];
                n10 = (int)(f2 * f);
                n11 = (int)(f3 * f);
                n12 = (int)(f4 * f);
                n13 = (int)(f5 * f);
                break;
            }
            case 90: {
                float f6 = fArray[1] - (float)n5;
                float f7 = fArray[0] - (float)n4;
                float f8 = fArray[3] - fArray[1];
                float f9 = fArray[2] - fArray[0];
                n10 = (int)(f6 * f);
                n11 = (int)(f7 * f);
                n12 = (int)(f8 * f);
                n13 = (int)(f9 * f);
                break;
            }
            case 180: {
                float f10 = fArray[2] - fArray[0];
                float f11 = fArray[3] - fArray[1];
                float f12 = fArray[1] - (float)n5;
                float f13 = (float)n7 - fArray[2] - (float)n9;
                n10 = (int)(f13 * f);
                n11 = (int)(f12 * f);
                n12 = (int)(f10 * f);
                n13 = (int)(f11 * f);
                break;
            }
            case 270: {
                float f14 = fArray[3] - fArray[1];
                float f15 = fArray[2] - fArray[0];
                float f16 = (float)n8 - fArray[3] - (float)this.cropOtherY[n];
                float f17 = (float)n7 - fArray[2] - (float)n9;
                n10 = (int)(f16 * f);
                n11 = (int)(f17 * f);
                n12 = (int)(f14 * f);
                n13 = (int)(f15 * f);
            }
        }
        return new int[]{n10, n11, n12, n13};
    }

    public boolean resetComponents(int n, int n2, boolean bl) {
        if (!super.resetComponents(n, n2, bl)) {
            return false;
        }
        if (!bl) {
            this.popups = new Component[0];
        }
        return true;
    }

    public void removeAllComponentsFromScreen() {
        if (this.panel != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.panel.removeAll();
            } else {
                Runnable runnable = new Runnable(){

                    public void run() {
                        SwingData.this.panel.removeAll();
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    public void setRootDisplayComponent(final Object object) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.panel = (JPanel)object;
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    SwingData.this.panel = (JPanel)object;
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    protected Object checkGUIObjectResolved(int n) {
        FormObject formObject = (FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(n));
        Object object = null;
        if (formObject != null) {
            object = formObject.getGUIComponent();
        }
        if (formObject != null && object == null && formObject != null && (object = this.resolveGUIComponent(formObject, n)) != null) {
            this.setGUIComp(formObject, n, object);
        }
        return object;
    }

    private Component resolveGUIComponent(FormObject formObject, int n) {
        Object object;
        Integer n2;
        if (formObject == null) {
            return null;
        }
        FormFactory formFactory = this.pdfDecoder.getFormRenderer().getFormFactory();
        int n3 = formObject.getParameterConstant(1147962727);
        boolean[] blArray = formObject.getFieldFlags();
        if (blArray != null) {
            boolean bl = blArray[1];
            boolean bl2 = blArray[2];
            boolean bl3 = blArray[3];
        }
        if (n3 == 1197118) {
            boolean bl = false;
            boolean bl4 = false;
            if (blArray != null) {
                bl = blArray[17];
                bl4 = blArray[16];
            }
            if (bl) {
                n2 = FormFactory.PUSHBUTTON;
                object = formFactory.pushBut(formObject);
            } else if (bl4) {
                n2 = FormFactory.RADIOBUTTON;
                object = formFactory.radioBut(formObject);
            } else {
                n2 = FormFactory.CHECKBOXBUTTON;
                object = formFactory.checkBoxBut(formObject);
            }
        } else if (n3 == 9288) {
            boolean bl = false;
            boolean bl5 = false;
            if (blArray != null) {
                bl = blArray[13];
                bl5 = blArray[14];
            }
            if (bl) {
                if (bl5) {
                    n2 = FormFactory.MULTILINEPASSWORD;
                    object = formFactory.multiLinePassword(formObject);
                } else {
                    n2 = FormFactory.MULTILINETEXT;
                    object = formFactory.multiLineText(formObject);
                }
            } else if (bl5) {
                n2 = FormFactory.SINGLELINEPASSWORD;
                object = formFactory.singleLinePassword(formObject);
            } else {
                n2 = FormFactory.SINGLELINETEXT;
                object = formFactory.singleLineText(formObject);
            }
        } else if (n3 == 4920) {
            boolean bl = false;
            if (blArray != null) {
                bl = blArray[18];
            }
            if (bl) {
                n2 = FormFactory.COMBOBOX;
                object = formFactory.comboBox(formObject);
            } else {
                n2 = FormFactory.LIST;
                object = formFactory.listField(formObject);
            }
        } else if (n3 == 2308407) {
            n2 = FormFactory.SIGNATURE;
            object = formFactory.signature(formObject);
        } else {
            n2 = FormFactory.ANNOTATION;
            object = formFactory.annotationButton(formObject);
        }
        this.completeField(formObject, n, -n2.intValue(), object, this.currentPdfFile);
        formObject.setGUIComponent(object);
        return (Component)object;
    }

    public void setGUIComp(FormObject formObject, int n, Object object) {
        Component component = (Component)object;
        int n2 = formObject.getPageNumber();
        String string = formObject.getTextStreamValue(36);
        if (string != null) {
            String string2 = formObject.getNormalOnState();
            if (string2 != null && string2.length() > 0) {
                string = string + "-(" + string2 + ')';
            }
            component.setName(string);
        }
        if (formObject.getParameterConstant(1147962727) == 1061176672) {
            component.setVisible(false);
        }
        this.scaleComponent(n2, this.displayScaling, this.rotation, n, component, true, false, this.indent);
    }

    public void resetScaledLocation(final float f, final int n, int n2) {
        if (this.trackPagesRendered == null) {
            return;
        }
        if (this.forceRedraw || f != this.lastScaling || (float)n != this.oldRotation || (float)n2 != this.oldIndent) {
            this.oldRotation = n;
            this.lastScaling = f;
            this.oldIndent = n2;
            this.forceRedraw = false;
            int n3 = this.startPage < this.trackPagesRendered.length ? this.trackPagesRendered[this.startPage] : 0;
            if (this.panel != null) {
                if (SwingUtilities.isEventDispatchThread()) {
                    for (int i = 0; i < this.popups.length; ++i) {
                        this.scaleComponent(this.currentPage, f, n, i, this.popups[i], true, true, this.indent);
                        this.panel.add(this.popups[i]);
                    }
                } else {
                    Runnable runnable = new Runnable(){

                        public void run() {
                            for (int i = 0; i < SwingData.this.popups.length; ++i) {
                                SwingData.this.scaleComponent(SwingData.this.currentPage, f, n, i, SwingData.this.popups[i], true, true, SwingData.this.indent);
                                SwingData.this.panel.add(SwingData.this.popups[i]);
                            }
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            }
            if (this.currentPage > 0 && n3 != -1 && this.nextFreeField + 1 > n3) {
                this.checkGUIObjectResolved(n3);
                FormObject formObject = (FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(n3));
                if (formObject != null) {
                    Component component = (Component)formObject.getGUIComponent();
                    while (formObject != null && n3 < this.nextFreeField + 1 && n3 > -1 && formObject.getPageNumber() >= this.startPage && formObject.getPageNumber() < this.endPage && component != null) {
                        if (this.panel != null) {
                            int n4;
                            Component component2;
                            Rectangle rectangle = formObject.getBoundingRectangle();
                            if (component instanceof JList && rectangle.height < component.getPreferredSize().height) {
                                component2 = (JList)component;
                                component = SwingData.wrapComponentInScrollPane((JList)component2);
                                formObject.setGUIComponent(component2);
                                n4 = ((JList)component2).getSelectedIndex();
                                if (n4 > -1) {
                                    ((JList)component2).ensureIndexIsVisible(n4);
                                }
                            }
                            if (SwingUtilities.isEventDispatchThread()) {
                                this.panel.remove(component);
                                this.scaleComponent(formObject.getPageNumber(), f, n, n3, component, true, false, this.indent);
                                this.panel.add(component);
                            } else {
                                component2 = component;
                                n4 = formObject.getPageNumber();
                                final int n5 = n3;
                                Runnable runnable = new Runnable(){

                                    public void run() {
                                        SwingData.this.panel.remove(component2);
                                        SwingData.this.scaleComponent(n4, f, n, n5, component2, true, false, SwingData.this.indent);
                                        SwingData.this.panel.add(component2);
                                    }
                                };
                                SwingUtilities.invokeLater(runnable);
                            }
                        }
                        if ((formObject = (FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(++n3))) == null) continue;
                        component = (Component)formObject.getGUIComponent();
                    }
                }
            }
        }
    }

    private static Component wrapComponentInScrollPane(JList jList) {
        JScrollPane jScrollPane = new JScrollPane(jList);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setLocation(jList.getLocation());
        jScrollPane.setPreferredSize(jList.getPreferredSize());
        jScrollPane.setSize(jList.getSize());
        return jScrollPane;
    }

    public void displayComponent(int n, FormObject formObject, Object object, int n2, int n3) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.scaleComponent(formObject.getPageNumber(), this.displayScaling, this.rotation, n, (Component)object, true, false, this.indent);
        } else {
            final int n4 = n;
            final int n5 = formObject.getPageNumber();
            final Component component = (Component)object;
            Runnable runnable = new Runnable(){

                public void run() {
                    SwingData.this.scaleComponent(n5, SwingData.this.displayScaling, SwingData.this.rotation, n4, component, true, false, SwingData.this.indent);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void syncKidValues(int n) {
        String string = this.convertIDtoRef(n);
        FormObject formObject = (FormObject)this.rawFormData.get(string);
        String string2 = formObject.getTextStreamValue(36);
        if (this.LastValueChanged.containsKey(string2)) {
            this.syncFormsByName(string2);
            this.LastValueChanged.remove(string2);
        }
    }

    public void syncAllValues() {
        for (Object k : this.LastValueByName.keySet()) {
            this.syncFormsByName((String)k);
        }
    }

    private void syncFormsByName(String string) {
        Object[] objectArray;
        Object v;
        block14: {
            if (!this.LastValueByName.containsKey(string)) {
                return;
            }
            v = this.LastValueByName.get(string);
            try {
                this.pdfDecoder.getFormRenderer().getComponentNameList();
            }
            catch (PdfException pdfException) {
                if (!LogWriter.isOutput()) break block14;
                LogWriter.writeLog("Exception: " + pdfException.getMessage());
            }
        }
        for (Object object : objectArray = this.getRawForm(string)) {
            Object object2;
            FormObject formObject;
            Object v2;
            if (object == null || (v2 = this.refToCompIndex.get((formObject = (FormObject)object).getObjectRefAsString())) == null) continue;
            int n = (Integer)v2;
            FormObject formObject2 = (FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(n));
            int n2 = formObject2.getFormType();
            this.checkGUIObjectResolved(n);
            Component component = (Component)formObject2.getGUIComponent();
            if (n2 == 8 || n2 == 9) {
                Icon icon;
                object2 = (JToggleButton)component;
                String string2 = formObject.getNormalOnState();
                if (string2 == null && v == null || string2 != null && string2.equals(v)) {
                    if (((AbstractButton)object2).isSelected()) continue;
                    ((AbstractButton)object2).setSelected(true);
                    icon = ((AbstractButton)object2).getPressedIcon();
                    if (icon == null || !(icon instanceof FixImageIcon)) continue;
                    ((FixImageIcon)icon).swapImage(true);
                    continue;
                }
                if (!((AbstractButton)object2).isSelected()) continue;
                ((AbstractButton)object2).setSelected(false);
                icon = ((AbstractButton)object2).getPressedIcon();
                if (icon == null || !(icon instanceof FixImageIcon)) continue;
                ((FixImageIcon)icon).swapImage(false);
                continue;
            }
            if (n2 == 2) {
                object2 = (JComboBox)component;
                if (((JComboBox)object2).getSelectedItem() == null) {
                    if (v == null) continue;
                    ((JComboBox)object2).setSelectedItem(v);
                    continue;
                }
                if (((JComboBox)object2).getSelectedItem().equals(v)) continue;
                ((JComboBox)object2).setSelectedItem(v);
                continue;
            }
            if (n2 != 4 && n2 != 3 && n2 != 6 && n2 != 5) continue;
            object2 = null;
            if (component instanceof JTextComponent) {
                object2 = ((JTextComponent)component).getText();
            } else if (component instanceof JButton) {
                object2 = ((ReadOnlyTextIcon)((JButton)component).getIcon()).getText();
            }
            if (v == null) {
                if (object2 == null) continue;
                if (component instanceof JTextComponent) {
                    ((JTextComponent)component).setText(null);
                    continue;
                }
                if (!(component instanceof JButton)) continue;
                ((ReadOnlyTextIcon)((JButton)component).getIcon()).setText("");
                continue;
            }
            if (v.equals(object2)) continue;
            if (component instanceof JTextComponent) {
                ((JTextComponent)component).setText(v.toString());
                continue;
            }
            if (!(component instanceof JButton)) continue;
            ((ReadOnlyTextIcon)((JButton)component).getIcon()).setText(v.toString());
        }
    }

    public void reportError(int n, Object[] objectArray) {
        if (!PdfDecoder.showErrorMessages) {
            return;
        }
        if (n == 1) {
            JOptionPane.showMessageDialog(this.panel, "The values entered does not match the format of the field [" + objectArray[0] + " ]", "Warning: Javascript Window", 1);
        } else if (n == 2) {
            JOptionPane.showMessageDialog(this.panel, "Invalid date/time: please ensure that the date/time exists. Field [" + objectArray[0] + " ] should match format " + objectArray[1], "Warning: Javascript Window", 1);
        } else if (n == 3) {
            JOptionPane.showMessageDialog(this.panel, objectArray[1], "Warning: Javascript Window", 1);
        } else {
            JOptionPane.showMessageDialog(this.panel, "The values entered does not match the format of the field", "Warning: Javascript Window", 1);
        }
    }

    public void invalidate(String string) {
        Object[] objectArray = this.getComponentsByName(string);
        if (objectArray == null) {
            return;
        }
        for (Object object : objectArray) {
            if (object == null) continue;
            ((Component)object).repaint();
        }
    }

    public void storeDisplayValue(String string) {
        Object v = this.refToCompIndex.get(string);
        if (v == null) {
            return;
        }
        int n = (Integer)v;
        FormObject formObject = (FormObject)this.rawFormData.get(string);
        Component component = (Component)this.checkGUIObjectResolved(n);
        FormObject formObject2 = (FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(n));
        int n2 = formObject2.getFormType();
        switch (n2) {
            case 2: {
                formObject.setSelectedItem((String)((JComboBox)component).getSelectedItem());
                break;
            }
            case 1: {
                formObject.setTopIndex(((JList)component).getSelectedIndices());
                break;
            }
            case 8: {
                JRadioButton jRadioButton = (JRadioButton)component;
                if (!jRadioButton.isSelected()) break;
                formObject.setChildOnState(FormUtils.removeStateToCheck(jRadioButton.getName(), true));
                break;
            }
            case 9: {
                JCheckBox jCheckBox = (JCheckBox)component;
                if (!jCheckBox.isSelected()) break;
                formObject.setCurrentState(FormUtils.removeStateToCheck(jCheckBox.getName(), true));
                break;
            }
            case 4: {
                formObject.setTextValue(((JTextComponent)component).getText());
                break;
            }
            case 6: {
                formObject.setTextValue(((JTextComponent)component).getText());
                break;
            }
            case 3: {
                if (!(component instanceof JTextComponent)) break;
                formObject.setTextValue(((JTextComponent)component).getText());
                break;
            }
            case 5: {
                if (!(component instanceof JTextComponent)) break;
                formObject.setTextValue(((JTextComponent)component).getText());
            }
        }
    }

    public void setCompVisible(String string, boolean bl) {
        Integer n = this.convertRefToID(string);
        if (n == null) {
            return;
        }
        ((Component)this.checkGUIObjectResolved(n)).setVisible(bl);
    }

    public void popup(FormObject formObject, PdfObjectReader pdfObjectReader) {
        JComponent jComponent;
        if (formObject.isPopupBuilt()) {
            jComponent = (JComponent)formObject.getPopupObj();
        } else {
            PdfObject pdfObject = formObject.getDictionary(1061176672);
            pdfObjectReader.checkResolved(pdfObject);
            if (pdfObject == null) {
                pdfObject = new FormObject();
                ((FormObject)pdfObject).copyInheritedValuesFromParent(formObject);
                ((FormObject)pdfObject).setParent(formObject.getObjectRefAsString());
            }
            jComponent = new PdfSwingPopup(formObject, pdfObject, this.pageData.getCropBoxWidth(this.currentPage));
            float[][] fArray = new float[this.popupBounds.length + 1][4];
            System.arraycopy(this.popupBounds, 0, fArray, 0, this.popupBounds.length);
            fArray[this.popupBounds.length] = pdfObject.getFloatArray(573911876);
            this.popupBounds = fArray;
            JComponent[] jComponentArray = new JComponent[this.popups.length + 1];
            System.arraycopy(this.popups, 0, jComponentArray, 0, this.popups.length);
            jComponentArray[this.popups.length] = jComponent;
            this.popups = jComponentArray;
            formObject.setPopupBuilt(jComponent);
            jComponent.setVisible(pdfObject.getBoolean(524301630));
            this.forceRedraw = true;
            this.resetScaledLocation(this.displayScaling, this.rotation, this.indent);
            this.panel.repaint();
        }
        if (jComponent.isVisible()) {
            jComponent.setVisible(false);
        } else {
            jComponent.setVisible(true);
        }
    }

    public void setTextColor(String string, Color color) {
        Integer n = this.convertRefToID(string);
        if (n == null) {
            return;
        }
        Object object = this.checkGUIObjectResolved(n);
        if (object != null) {
            ((Component)object).setForeground(color);
        }
    }

    public void setCustomPrintInterface(CustomFormPrint customFormPrint) {
        this.customFormPrint = customFormPrint;
    }

    public int getFieldType(Object object) {
        if (object instanceof FormObject) {
            return super.getFieldType(object);
        }
        if (object instanceof JTextField || object instanceof JTextArea || object instanceof JPasswordField) {
            return 0;
        }
        if (object instanceof JRadioButton || object instanceof JCheckBox || object instanceof JButton) {
            return 1;
        }
        if (object instanceof JList || object instanceof JComboBox) {
            return 2;
        }
        return -1;
    }

    public void flagLastUsedValue(Object object, FormObject formObject, boolean bl) {
        JToggleButton jToggleButton;
        Component component = (Component)object;
        String string = formObject.getStringKey(1110793845);
        String string2 = formObject.getTextStreamValue(36);
        if (string != null) {
            if (component instanceof JComboBox) {
                this.LastValueByName.put(string2, ((JComboBox)component).getSelectedItem());
                this.LastValueChanged.put(string2, null);
            } else if (component instanceof JTextComponent) {
                this.LastValueByName.put(string2, ((JTextComponent)component).getText());
                this.LastValueChanged.put(string2, null);
            } else if (component instanceof JToggleButton) {
                boolean bl2 = ((JToggleButton)component).isSelected();
                if (bl2) {
                    this.LastValueByName.put(string2, formObject.getNormalOnState());
                    this.LastValueChanged.put(string2, null);
                } else if (!bl2 && this.LastValueByName.get(formObject.getTextStreamValue(36)) != null) {
                    String string3 = formObject.getNormalOnState();
                    if (this.LastValueByName.get(formObject.getTextStreamValue(36)).equals(string3)) {
                        if (formObject.getFieldFlags()[15]) {
                            ((JToggleButton)component).setSelected(true);
                            Icon icon = ((JToggleButton)component).getPressedIcon();
                            if (icon != null && icon instanceof FixImageIcon) {
                                ((FixImageIcon)icon).swapImage(true);
                            }
                        } else {
                            this.LastValueChanged.put(string2, null);
                        }
                    }
                }
            }
        } else if (component instanceof JToggleButton && !(jToggleButton = (JToggleButton)component).isSelected() && formObject.getFieldFlags()[15]) {
            jToggleButton.setSelected(true);
            Icon icon = jToggleButton.getPressedIcon();
            if (icon != null && icon instanceof FixImageIcon) {
                ((FixImageIcon)icon).swapImage(true);
            }
        }
        if (bl) {
            this.syncFormsByName(FormUtils.removeStateToCheck(component.getName(), false));
        }
    }

    public void setCompVisible(Object object, boolean bl) {
        ((Component)object).setVisible(bl);
    }
}

