/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects;

import org.jpedal.io.DecryptionFactory;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.MetadataObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.StringUtils;

public class PdfFileInformation {
    private static final String[] information_fields = new String[]{"Title", "Author", "Subject", "Keywords", "Creator", "Producer", "CreationDate", "ModDate", "Trapped"};
    public static final int[] information_field_IDs = new int[]{960773209, 1144541319, 978876534, 1517780362, 827818359, 1702196342, 1806481572, 340689769, 1080325989};
    private String[] information_values = new String[]{"", "", "", "", "", "", "", "", ""};
    private String XMLmetadata = null;
    private byte[] rawData = null;

    public static String[] getFieldNames() {
        return information_fields;
    }

    public String getFileXMLMetaData() {
        if (this.rawData == null) {
            return "";
        }
        if (this.XMLmetadata == null) {
            int n = this.rawData.length;
            byte[] byArray = new byte[n];
            System.arraycopy(this.rawData, 0, byArray, 0, n);
            int n2 = byArray.length;
            int n3 = 0;
            int n4 = 0;
            for (int i = 0; i < n2; ++i) {
                if (n4 == 13 && byArray[i] == 10) {
                    byArray[n3 - 1] = 10;
                    continue;
                }
                if (!(n4 != 10 && n4 != 32 || byArray[i] != 32 && byArray[i] != 10)) continue;
                byArray[n3] = byArray[i];
                n4 = byArray[i];
                ++n3;
            }
            if (n3 != n2) {
                byte[] byArray2 = new byte[n3];
                System.arraycopy(byArray, 0, byArray2, 0, n3);
                byArray = byArray2;
            }
            this.XMLmetadata = new String(byArray);
        }
        return this.XMLmetadata;
    }

    public void setFileXMLMetaData(byte[] byArray) {
        this.rawData = byArray;
    }

    public String[] getFieldValues() {
        return this.information_values;
    }

    public void setFieldValue(int n, String string) {
        this.information_values[n] = string;
    }

    public void readInformationObject(PdfObject pdfObject, ObjectDecoder objectDecoder) {
        block6: {
            try {
                objectDecoder.checkResolved(pdfObject);
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block6;
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
        }
        int n = information_field_IDs.length;
        for (int i = 0; i < n; ++i) {
            String string;
            int n2 = information_field_IDs[i];
            if (n2 == 1080325989) {
                string = pdfObject.getName(n2);
                if (string == null) {
                    string = "";
                }
            } else {
                byte[] byArray = pdfObject.getTextStreamValueAsByte(n2);
                string = byArray == null ? "" : StringUtils.getTextString(byArray, false);
            }
            this.setFieldValue(i, string);
        }
    }

    public final PdfFileInformation readPdfFileMetadata(PdfObject pdfObject, PdfObjectReader pdfObjectReader) {
        PdfFileReader pdfFileReader = pdfObjectReader.getObjectReader();
        ObjectDecoder objectDecoder = new ObjectDecoder(pdfObjectReader.getObjectReader());
        DecryptionFactory decryptionFactory = pdfFileReader.getDecryptionObject();
        PdfObject pdfObject2 = pdfFileReader.getInfoObject();
        if (pdfObject2 != null && (decryptionFactory == null || !decryptionFactory.getBooleanValue(101) && !decryptionFactory.getBooleanValue(104))) {
            this.readInformationObject(pdfObject2, objectDecoder);
        }
        if (pdfObject != null) {
            String string = new String(pdfObject.getUnresolvedData());
            MetadataObject metadataObject = new MetadataObject(string);
            pdfFileReader.readObject(metadataObject);
            byte[] byArray = metadataObject.getDecodedStream();
            this.rawData = byArray;
            if (this.rawData != null) {
                int n;
                for (n = this.rawData.length; n > 1 && this.rawData[n - 1] != 62; --n) {
                }
                if (n > 0) {
                    byte[] byArray2 = new byte[n];
                    System.arraycopy(this.rawData, 0, byArray2, 0, n);
                    this.rawData = byArray2;
                }
            }
        }
        return this;
    }
}

