/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.jpedal.constants.PDFflags;
import org.jpedal.exception.PdfSecurityException;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.SetSecurity;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfKeyPairsIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.ObjectCloneFactory;

public class DecryptionFactory {
    private Map cachedObjects = new HashMap();
    private boolean extractionIsAllowed = true;
    private boolean isInitialised = false;
    private boolean isMetaDataEncypted = true;
    private boolean isPasswordSupplied = false;
    private boolean stringsEncoded = false;
    private boolean isEncrypted = false;
    private byte[] encryptionKey = null;
    private int rev = 0;
    private int P = 0;
    private byte[] O = null;
    private byte[] U = null;
    private byte[] OE = null;
    private byte[] Perms = null;
    private byte[] UE = null;
    Cipher cipher = null;
    private boolean isAES = false;
    private PdfObject StmFObj;
    private PdfObject StrFObj;
    private static boolean alwaysReinitCipher = false;
    private final String[] pad = new String[]{"28", "BF", "4E", "5E", "4E", "75", "8A", "41", "64", "00", "4E", "56", "FF", "FA", "01", "08", "2E", "2E", "00", "B6", "D0", "68", "3E", "80", "2F", "0C", "A9", "FE", "64", "53", "69", "7A"};
    private boolean isAESIdentity = false;
    private int keyLength = 5;
    private boolean isFileViewable = true;
    private int passwordStatus = 0;
    private byte[] ID = null;
    private byte[] encryptionPassword = null;
    private Certificate certificate;
    private Key key;

    public DecryptionFactory(byte[] byArray, byte[] byArray2) {
        this.ID = byArray;
        this.encryptionPassword = byArray2;
    }

    public DecryptionFactory(byte[] byArray, Certificate certificate, PrivateKey privateKey) {
        this.ID = byArray;
        this.certificate = certificate;
        this.key = privateKey;
    }

    private boolean testPassword() throws PdfSecurityException {
        int n = 32;
        byte[] byArray = new byte[32];
        for (int i = 0; i < 32; ++i) {
            byArray[i] = (byte)Integer.parseInt(this.pad[i], 16);
        }
        byte[] byArray2 = ObjectCloneFactory.cloneArray(byArray);
        if (this.rev == 2) {
            this.encryptionKey = this.calculateKey(this.O, this.P, this.ID);
            byArray2 = this.decrypt(byArray2, "", true, null, false, false);
        } else if (this.rev >= 3) {
            MessageDigest messageDigest;
            byte[] byArray3;
            int n2;
            block9: {
                int n3;
                n2 = this.keyLength;
                if (this.rev == 4 && this.StmFObj != null && (n3 = this.StmFObj.getInt(1043816557)) != -1) {
                    n2 = n3;
                }
                n = 16;
                this.encryptionKey = this.calculateKey(this.O, this.P, this.ID);
                byArray3 = ObjectCloneFactory.cloneArray(this.encryptionKey);
                messageDigest = null;
                try {
                    messageDigest = MessageDigest.getInstance("MD5");
                }
                catch (Exception exception) {
                    if (!LogWriter.isOutput()) break block9;
                    LogWriter.writeLog("Exception " + exception + " with digest");
                }
            }
            messageDigest.update(byArray2);
            byte[] byArray4 = messageDigest.digest(this.ID);
            byArray4 = this.decrypt(byArray4, "", true, null, true, false);
            byte[] byArray5 = new byte[n2];
            for (int i = 1; i <= 19; ++i) {
                for (int j = 0; j < n2; ++j) {
                    byArray5[j] = (byte)(byArray3[j] ^ i);
                }
                this.encryptionKey = byArray5;
                byArray4 = this.decrypt(byArray4, "", true, null, true, false);
            }
            this.encryptionKey = byArray3;
            byArray2 = new byte[32];
            System.arraycopy(byArray4, 0, byArray2, 0, 16);
            System.arraycopy(byArray, 0, byArray2, 16, 16);
        }
        return DecryptionFactory.compareKeys(this.U, byArray2, n);
    }

    private static boolean compareKeys(byte[] byArray, byte[] byArray2, int n) {
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            bl = false;
            i = byArray.length;
        }
        return bl;
    }

    private void computeEncryptionKey() throws PdfSecurityException {
        byte[] byArray = this.getPaddedKey(this.encryptionPassword);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            this.encryptionKey = messageDigest.digest(byArray);
            if (this.rev >= 3) {
                for (int i = 0; i < 50; ++i) {
                    this.encryptionKey = messageDigest.digest(this.encryptionKey);
                }
            }
        }
        catch (Exception exception) {
            throw new PdfSecurityException("Exception " + exception + " generating encryption key");
        }
    }

    private boolean testOwnerPassword() throws PdfSecurityException {
        int n;
        byte[] byArray = this.encryptionPassword;
        byte[] byArray2 = new byte[this.keyLength];
        byte[] byArray3 = ObjectCloneFactory.cloneArray(this.O);
        this.computeEncryptionKey();
        byte[] byArray4 = ObjectCloneFactory.cloneArray(this.encryptionKey);
        if (this.rev == 2) {
            byArray2 = this.decrypt(ObjectCloneFactory.cloneArray(this.O), "", false, null, false, false);
        } else if (this.rev >= 3) {
            int n2;
            n = this.keyLength;
            if (this.rev == 4 && this.StmFObj != null && (n2 = this.StmFObj.getInt(1043816557)) != -1) {
                n = n2;
            }
            byArray2 = byArray3;
            byte[] byArray5 = new byte[n];
            for (int i = 19; i >= 0; --i) {
                for (int j = 0; j < n; ++j) {
                    byArray5[j] = (byte)(byArray4[j] ^ i);
                }
                this.encryptionKey = byArray5;
                byArray2 = this.decrypt(byArray2, "", false, null, true, false);
            }
        }
        this.encryptionPassword = byArray2;
        this.computeEncryptionKey();
        n = this.testPassword() ? 1 : 0;
        if (n == 0) {
            this.encryptionPassword = byArray;
            this.computeEncryptionKey();
        }
        return n != 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void verifyAccess() throws PdfSecurityException {
        boolean bl;
        boolean bl2;
        block13: {
            this.isPasswordSupplied = false;
            this.extractionIsAllowed = false;
            this.passwordStatus = 0;
            bl2 = false;
            bl = false;
            if (this.rev < 5) {
                bl2 = this.testOwnerPassword();
                bl = this.testPassword();
            } else {
                try {
                    bl2 = DecryptionFactory.compareKeys(this.O, this.getV5Key(true, 32), 32);
                    if (bl2) {
                        this.encryptionKey = DecryptionFactory.v5Decrypt(this.OE, this.getV5Key(true, 32));
                    } else {
                        bl = DecryptionFactory.compareKeys(this.U, this.getV5Key(false, 32), 32);
                        if (bl) {
                            this.encryptionKey = DecryptionFactory.v5Decrypt(this.UE, this.getV5Key(false, 40));
                        }
                    }
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    if (!LogWriter.isOutput()) break block13;
                    LogWriter.writeLog("Exception: " + noSuchAlgorithmException.getMessage());
                }
            }
        }
        if (bl2) {
            this.passwordStatus = 2;
        }
        if (bl) {
            ++this.passwordStatus;
        }
        if (!bl2) {
            if (!bl) throw new PdfSecurityException("No valid password supplied");
            if (this.encryptionPassword != null && this.encryptionPassword.length > 0 && LogWriter.isOutput()) {
                LogWriter.writeLog("Correct user password supplied ");
            }
            this.isFileViewable = true;
            this.isPasswordSupplied = true;
            if ((this.P & 0x10) != 16) return;
            this.extractionIsAllowed = true;
            return;
        } else {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Correct owner password supplied");
            }
            this.isFileViewable = true;
            this.isPasswordSupplied = true;
            this.extractionIsAllowed = true;
        }
    }

    private static byte[] v5Decrypt(byte[] byArray, byte[] byArray2) throws PdfSecurityException {
        int n = byArray.length;
        byte[] byArray3 = new byte[n];
        try {
            int n2;
            CBCBlockCipher cBCBlockCipher = new CBCBlockCipher((BlockCipher)new AESFastEngine());
            cBCBlockCipher.init(false, (CipherParameters)new KeyParameter(byArray2));
            for (int i = 0; i < n; i += n2) {
                cBCBlockCipher.processBlock(byArray, i, byArray3, i);
                n2 = cBCBlockCipher.getBlockSize();
            }
        }
        catch (Exception exception) {
            throw new PdfSecurityException("Exception " + exception.getMessage() + " with v5 encoding");
        }
        return byArray3;
    }

    private byte[] getV5Key(boolean bl, int n) throws NoSuchAlgorithmException {
        int n2;
        byte[] byArray = this.encryptionPassword;
        if (byArray == null) {
            byArray = new byte[]{};
        }
        if ((n2 = byArray.length) > 127) {
            n2 = 127;
        }
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        messageDigest.update(byArray, 0, n2);
        if (bl) {
            messageDigest.update(this.O, n, 8);
            messageDigest.update(this.U, 0, 48);
        } else {
            messageDigest.update(this.U, n, 8);
        }
        return messageDigest.digest();
    }

    private byte[] getPaddedKey(byte[] byArray) {
        byte[] byArray2 = new byte[32];
        int n = 0;
        if (byArray != null && (n = byArray.length) > 32) {
            n = 32;
        }
        if (this.encryptionPassword != null) {
            System.arraycopy(this.encryptionPassword, 0, byArray2, 0, n);
        }
        for (int i = n; i < 32; ++i) {
            byArray2[i] = (byte)Integer.parseInt(this.pad[i - n], 16);
        }
        return byArray2;
    }

    private byte[] calculateKey(byte[] byArray, int n, byte[] byArray2) throws PdfSecurityException {
        byte[] byArray3;
        Object object;
        byte[] byArray4 = this.getPaddedKey(this.encryptionPassword);
        try {
            object = MessageDigest.getInstance("MD5");
            ((MessageDigest)object).update(byArray4);
            ((MessageDigest)object).update(byArray);
            ((MessageDigest)object).update(new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 24 & 0xFF)});
            if (byArray2 != null) {
                ((MessageDigest)object).update(byArray2);
            }
            if (this.rev == 4 && !this.isMetaDataEncypted) {
                ((MessageDigest)object).update(new byte[]{-1, -1, -1, -1});
            }
            byte[] byArray5 = new byte[this.keyLength];
            System.arraycopy(((MessageDigest)object).digest(), 0, byArray5, 0, this.keyLength);
            if (this.rev >= 3) {
                for (int i = 0; i < 50; ++i) {
                    System.arraycopy(((MessageDigest)object).digest(byArray5), 0, byArray5, 0, this.keyLength);
                }
            }
            byArray3 = new byte[this.keyLength];
            System.arraycopy(byArray5, 0, byArray3, 0, this.keyLength);
        }
        catch (Exception exception) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
            throw new PdfSecurityException("Exception " + exception + " generating encryption key");
        }
        object = new byte[this.keyLength];
        System.arraycopy(byArray3, 0, object, 0, this.keyLength);
        return object;
    }

    public void readEncryptionObject(PdfObject pdfObject) throws PdfSecurityException {
        this.stringsEncoded = false;
        this.isMetaDataEncypted = true;
        this.StmFObj = null;
        this.StrFObj = null;
        this.isAES = false;
        if (!this.isInitialised) {
            this.isInitialised = true;
            SetSecurity.init();
        }
        int n = pdfObject.getInt(38);
        PdfArrayIterator pdfArrayIterator = pdfObject.getMixedArray(1011108731);
        int n2 = 1467315058;
        if (pdfArrayIterator != null && pdfArrayIterator.hasMoreTokens()) {
            n2 = pdfArrayIterator.getNextValueAsConstant(false);
        }
        if (n == 3) {
            throw new PdfSecurityException("Unsupported Custom Adobe Encryption method");
        }
        if (n > 4 && n2 != 1467315058) {
            throw new PdfSecurityException("Unsupported Encryption method");
        }
        int n3 = pdfObject.getInt(1043816557) >> 3;
        if (n3 != -1) {
            this.keyLength = n3;
        }
        this.rev = pdfObject.getInt(34);
        this.P = pdfObject.getInt(32);
        this.O = pdfObject.getTextStreamValueAsByte(31);
        this.U = pdfObject.getTextStreamValueAsByte(37);
        this.OE = pdfObject.getTextStreamValueAsByte(7957);
        this.UE = pdfObject.getTextStreamValueAsByte(9493);
        this.Perms = pdfObject.getTextStreamValueAsByte(893533539);
        if (n >= 4) {
            String string;
            PdfKeyPairsIterator pdfKeyPairsIterator;
            this.isAES = true;
            PdfObject pdfObject2 = pdfObject.getDictionary(4886);
            if (n == 4) {
                this.isMetaDataEncypted = pdfObject.getBoolean(-1815804199);
            }
            this.isAESIdentity = false;
            String string2 = pdfObject.getName(591675926);
            if (string2 != null) {
                this.isAESIdentity = string2.equals("Identity");
                this.stringsEncoded = true;
                pdfKeyPairsIterator = pdfObject2.getKeyPairsIterator();
                while (pdfKeyPairsIterator.hasMorePairs()) {
                    string = pdfKeyPairsIterator.getNextKeyAsString();
                    if (string.equals(string2)) {
                        this.StrFObj = pdfKeyPairsIterator.getNextValueAsDictionary();
                    }
                    pdfKeyPairsIterator.nextPair();
                }
            }
            if ((string2 = pdfObject.getName(591674646)) != null) {
                this.isAESIdentity = string2.equals("Identity");
                pdfKeyPairsIterator = pdfObject2.getKeyPairsIterator();
                while (pdfKeyPairsIterator.hasMorePairs()) {
                    string = pdfKeyPairsIterator.getNextKeyAsString();
                    if (string.equals(string2)) {
                        this.StmFObj = pdfKeyPairsIterator.getNextValueAsDictionary();
                    }
                    pdfKeyPairsIterator.nextPair();
                }
            }
        }
        this.isEncrypted = true;
        this.isFileViewable = false;
        if (LogWriter.isOutput()) {
            LogWriter.writeLog("File has encryption settings");
        }
        if (n2 == 1467315058) {
            try {
                this.verifyAccess();
            }
            catch (PdfSecurityException pdfSecurityException) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("File requires password");
                }
            }
        } else if (this.certificate != null) {
            this.isFileViewable = true;
            this.isPasswordSupplied = true;
            this.extractionIsAllowed = true;
            this.passwordStatus = 2;
        }
        if (this.rev == 5) {
            this.Perms = DecryptionFactory.v5Decrypt(this.Perms, this.encryptionKey);
            this.isMetaDataEncypted = this.Perms[8] == 84;
            this.P = this.Perms[0] & 0xFF | (this.Perms[1] & 0xFF) << 8 | (this.Perms[2] & 0xFF) << 16 | (this.Perms[2] & 0xFF) << 24;
        }
    }

    private void setPasswordFromCertificate(PdfObject pdfObject) {
        block5: {
            byte[] byArray;
            byte[][] byArray2 = pdfObject.getStringArray(1752671921);
            if (byArray2 != null && (byArray = SetSecurity.extractCertificateData(byArray2, this.certificate, this.key)) != null) {
                try {
                    MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
                    messageDigest.update(byArray, 0, 20);
                    for (byte[] byArray3 : byArray2) {
                        messageDigest.update(byArray3);
                    }
                    if (!this.isMetaDataEncypted) {
                        messageDigest.update(new byte[]{-1, -1, -1, -1});
                    }
                    this.encryptionKey = messageDigest.digest();
                }
                catch (Exception exception) {
                    if (!LogWriter.isOutput()) break block5;
                    LogWriter.writeLog("Exception: " + exception.getMessage());
                }
            }
        }
    }

    public byte[] decrypt(byte[] byArray, String string, boolean bl, String string2, boolean bl2, boolean bl3) throws PdfSecurityException {
        if (this.getBooleanValue(101) || bl) {
            int n;
            Object object;
            Object object2;
            byte[] byArray2;
            boolean bl4;
            BufferedInputStream bufferedInputStream;
            BufferedOutputStream bufferedOutputStream;
            block36: {
                bufferedOutputStream = null;
                bufferedInputStream = null;
                bl4 = false;
                byArray2 = null;
                if (string2 != null) {
                    try {
                        Object object3;
                        if (byArray == null) {
                            byArray2 = new byte[16];
                            object3 = new FileInputStream(string2);
                            ((FileInputStream)object3).read(byArray2);
                            ((FileInputStream)object3).close();
                        }
                        object3 = File.createTempFile("jpedal", ".raw", new File(ObjectStore.temp_dir));
                        this.cachedObjects.put(((File)object3).getAbsolutePath(), "x");
                        ObjectStore.copy(string2, ((File)object3).getAbsolutePath());
                        object2 = new File(string2);
                        ((File)object2).delete();
                        bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
                        bufferedInputStream = new BufferedInputStream(new FileInputStream((File)object3));
                    }
                    catch (IOException iOException) {
                        if (!LogWriter.isOutput()) break block36;
                        LogWriter.writeLog("Exception " + iOException + " in decrypt");
                    }
                }
            }
            int n2 = this.keyLength;
            object2 = "RC4";
            String string3 = "RC4";
            IvParameterSpec ivParameterSpec = null;
            PdfObject pdfObject = !bl3 ? this.StmFObj : this.StrFObj;
            if (this.certificate != null) {
                this.setPasswordFromCertificate(pdfObject);
                pdfObject.setIntNumber(1043816557, 16);
            }
            if (!bl2 && pdfObject == null && this.isAESIdentity) {
                return byArray;
            }
            if (pdfObject != null) {
                int n3 = pdfObject.getInt(1043816557);
                if (n3 != -1) {
                    n2 = n3;
                }
                if ((object = pdfObject.getName(1250845)) != null && !bl2 && (((String)object).equals("AESV2") || ((String)object).equals("AESV3"))) {
                    this.cipher = null;
                    object2 = "AES/CBC/PKCS5Padding";
                    string3 = "AES";
                    bl4 = true;
                    byte[] byArray3 = new byte[16];
                    if (byArray2 != null) {
                        System.arraycopy(byArray2, 0, byArray3, 0, 16);
                    } else {
                        System.arraycopy(byArray, 0, byArray3, 0, 16);
                    }
                    ivParameterSpec = new IvParameterSpec(byArray3);
                    if (byArray == null) {
                        try {
                            bufferedInputStream.skip(16L);
                        }
                        catch (IOException iOException) {
                            if (LogWriter.isOutput()) {
                                LogWriter.writeLog("Exception: " + iOException.getMessage());
                            }
                        }
                    } else {
                        int n4 = byArray.length;
                        n = n4 - 16;
                        byte[] byArray4 = new byte[n];
                        System.arraycopy(byArray, 16, byArray4, 0, n);
                        byArray = byArray4;
                        int n5 = byArray.length & 0xF;
                        int n6 = byArray.length;
                        if (n5 > 0) {
                            n6 = n6 + 16 - n5;
                            byArray4 = new byte[n6];
                            System.arraycopy(byArray, 0, byArray4, 0, byArray.length);
                            byArray = byArray4;
                        }
                    }
                }
            }
            byte[] byArray5 = new byte[n2];
            if (string.length() > 0) {
                byArray5 = new byte[n2 + 5];
            }
            System.arraycopy(this.encryptionKey, 0, byArray5, 0, n2);
            try {
                if (this.rev == 5) {
                    object = new byte[32];
                    System.arraycopy(byArray5, 0, object, 0, ((Object)object).length);
                } else {
                    if (string.length() > 0) {
                        int n7 = string.indexOf(32);
                        int n8 = string.indexOf(32, n7 + 1);
                        n = Integer.parseInt(string.substring(0, n7));
                        int n9 = Integer.parseInt(string.substring(n7 + 1, n8));
                        byArray5[n2] = (byte)(n & 0xFF);
                        byArray5[n2 + 1] = (byte)(n >> 8 & 0xFF);
                        byArray5[n2 + 2] = (byte)(n >> 16 & 0xFF);
                        byArray5[n2 + 3] = (byte)(n9 & 0xFF);
                        byArray5[n2 + 4] = (byte)(n9 >> 8 & 0xFF);
                    }
                    object = new byte[Math.min(byArray5.length, 16)];
                    if (string.length() > 0) {
                        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                        messageDigest.update(byArray5);
                        if (bl4 && n2 >= 16) {
                            byte[] byArray6 = new byte[]{115, 65, 108, 84};
                            messageDigest.update(byArray6);
                        }
                        System.arraycopy(messageDigest.digest(), 0, object, 0, ((Object)object).length);
                    } else {
                        System.arraycopy(byArray5, 0, object, 0, ((Object)object).length);
                    }
                }
                if (this.cipher == null) {
                    this.cipher = Cipher.getInstance((String)object2);
                }
                SecretKeySpec secretKeySpec = new SecretKeySpec((byte[])object, string3);
                if (bl) {
                    this.cipher.init(1, secretKeySpec);
                } else if (ivParameterSpec == null) {
                    this.cipher.init(2, secretKeySpec);
                } else {
                    this.cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
                }
                if (bufferedOutputStream != null) {
                    CipherInputStream cipherInputStream = new CipherInputStream(bufferedInputStream, this.cipher);
                    while ((n = cipherInputStream.read()) != -1) {
                        bufferedOutputStream.write(n);
                    }
                    cipherInputStream.close();
                    bufferedOutputStream.close();
                    bufferedInputStream.close();
                }
                if (byArray != null) {
                    byArray = this.cipher.doFinal(byArray);
                }
            }
            catch (Exception exception) {
                throw new PdfSecurityException("Exception " + exception + " decrypting content");
            }
        }
        if (alwaysReinitCipher) {
            this.cipher = null;
        }
        return byArray;
    }

    public boolean getBooleanValue(int n) {
        switch (n) {
            case 100: {
                return this.isFileViewable;
            }
            case 101: {
                return this.isEncrypted;
            }
            case 102: {
                return this.isMetaDataEncypted;
            }
            case 103: {
                return this.extractionIsAllowed;
            }
            case 104: {
                return this.isPasswordSupplied;
            }
        }
        return false;
    }

    public byte[] decryptString(byte[] byArray, String string) throws PdfSecurityException {
        block3: {
            try {
                if (!this.isAES || this.stringsEncoded || this.isMetaDataEncypted) {
                    byArray = this.decrypt(byArray, string, false, null, false, true);
                }
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block3;
                LogWriter.writeLog("Unable to decrypt string in Object " + string + ' ' + new String(byArray));
            }
        }
        return byArray;
    }

    public int getPDFflag(Integer n) {
        if (n.equals(PDFflags.USER_ACCESS_PERMISSIONS)) {
            return this.P;
        }
        if (n.equals(PDFflags.VALID_PASSWORD_SUPPLIED)) {
            return this.passwordStatus;
        }
        return -1;
    }

    public void reset(byte[] byArray) {
        this.encryptionPassword = byArray;
        this.cipher = null;
    }

    public void flush() {
        if (this.cachedObjects != null) {
            for (Object k : this.cachedObjects.keySet()) {
                String string = (String)k;
                File file = new File(string);
                file.delete();
                if (!LogWriter.isOutput() || !file.exists()) continue;
                LogWriter.writeLog("Unable to delete temp file " + string);
            }
        }
    }

    public void dispose() {
        this.cachedObjects = null;
    }

    public boolean hasPassword() {
        return this.O != null || this.U != null;
    }

    static {
        String string = System.getProperty("org.jpedal.cipher.reinit");
        if (string != null && string.toLowerCase().equals("true")) {
            alwaysReinitCipher = true;
        }
    }
}

