/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.popups;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.jpedal.io.ObjectStore;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class FileDownload {
    File tempURLFile;
    boolean downloadCreated = false;
    JFrame download = null;
    JPanel p;
    JProgressBar pb;
    JLabel downloadMessage;
    JLabel downloadFile;
    JLabel turnOff;
    int downloadCount = 0;
    boolean visible = true;
    String progress = "";
    Point coords = null;

    public FileDownload(boolean bl, Point point) {
        this.visible = bl;
        this.coords = point;
        if (this.visible) {
            this.download = new JFrame();
            this.p = new JPanel(new GridBagLayout());
            this.pb = new JProgressBar();
            this.downloadMessage = new JLabel();
            this.downloadFile = new JLabel();
            this.turnOff = new JLabel();
            this.download.setResizable(false);
            this.download.setTitle(Messages.getMessage("PageLayoutViewMenu.DownloadWindowTitle"));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 2;
            this.downloadFile.setSize(250, this.downloadFile.getHeight());
            this.downloadFile.setMinimumSize(new Dimension(250, 15));
            this.downloadFile.setMaximumSize(new Dimension(250, 15));
            this.downloadFile.setPreferredSize(new Dimension(250, 15));
            this.p.add((Component)this.downloadFile, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            this.downloadMessage.setSize(250, this.downloadFile.getHeight());
            this.downloadMessage.setMinimumSize(new Dimension(250, 15));
            this.downloadMessage.setMaximumSize(new Dimension(250, 15));
            this.downloadMessage.setPreferredSize(new Dimension(250, 15));
            this.p.add((Component)this.downloadMessage, gridBagConstraints);
            gridBagConstraints.gridy = 2;
            this.pb.setSize(260, this.downloadFile.getHeight());
            this.pb.setMinimumSize(new Dimension(260, 20));
            this.pb.setMaximumSize(new Dimension(260, 20));
            this.pb.setPreferredSize(new Dimension(260, 20));
            this.p.add((Component)this.pb, gridBagConstraints);
            gridBagConstraints.gridy = 3;
            this.p.add((Component)this.turnOff, gridBagConstraints);
            this.download.getContentPane().add(this.p);
            this.download.setSize(320, 100);
            this.downloadCreated = true;
        }
    }

    public File createWindow(String string) {
        try {
            int n;
            String string2;
            Object object;
            URL uRL = new URL(string);
            InputStream inputStream = uRL.openStream();
            String string3 = uRL.getPath().substring(uRL.getPath().lastIndexOf(47) + 1);
            int n2 = uRL.openConnection().getContentLength();
            String string4 = string3;
            this.tempURLFile = File.createTempFile(string4.substring(0, string4.lastIndexOf(46)), string4.substring(string4.lastIndexOf(46)), new File(ObjectStore.temp_dir));
            FileOutputStream fileOutputStream = new FileOutputStream(this.tempURLFile);
            if (this.visible && this.coords != null) {
                this.download.setLocation(this.coords.x - this.download.getWidth() / 2, this.coords.y - this.download.getHeight() / 2);
                this.download.setVisible(true);
            }
            if (this.visible) {
                this.pb.setMinimum(0);
                this.pb.setMaximum(n2);
                object = Messages.getMessage("PageLayoutViewMenu.DownloadWindowMessage");
                object = ((String)object).replaceAll("FILENAME", string4);
                this.downloadFile.setText((String)object);
                Font font = this.turnOff.getFont();
                this.turnOff.setFont(new Font(font.getName(), font.getStyle(), 8));
                this.turnOff.setAlignmentY(1.0f);
                this.turnOff.setText(Messages.getMessage("PageLayoutViewMenu.DownloadWindowTurnOff"));
            }
            object = new byte[4096];
            int n3 = 0;
            String string5 = "kb";
            int n4 = 1000;
            if (n2 > 1000000) {
                string5 = "mb";
                n4 = 1000000;
            }
            if (this.visible) {
                this.progress = Messages.getMessage("PageLayoutViewMenu.DownloadWindowProgress");
                if (n2 < 1000000) {
                    this.progress = this.progress.replaceAll("DVALUE", n2 / n4 + " " + string5);
                } else {
                    string2 = String.valueOf(n2 % n4 / 10000);
                    if (n2 % n4 / 10000 < 10) {
                        string2 = '0' + string2;
                    }
                    this.progress = this.progress.replaceAll("DVALUE", n2 / n4 + "." + string2 + ' ' + string5);
                }
            }
            while ((n = inputStream.read((byte[])object)) != -1) {
                n3 += n;
                this.downloadCount += n;
                if (this.visible) {
                    if (n2 < 1000000) {
                        this.downloadMessage.setText(this.progress.replaceAll("DSOME", n3 / n4 + " " + string5));
                    } else {
                        string2 = String.valueOf(n3 % n4 / 10000);
                        if (n3 % n4 / 10000 < 10) {
                            string2 = '0' + string2;
                        }
                        this.downloadMessage.setText(this.progress.replaceAll("DSOME", n3 / n4 + "." + string2 + ' ' + string5));
                    }
                    this.pb.setValue(n3);
                    this.download.repaint();
                }
                fileOutputStream.write((byte[])object, 0, n);
            }
            fileOutputStream.flush();
            inputStream.close();
            fileOutputStream.close();
            if (this.visible) {
                this.downloadMessage.setText("Download of " + string4 + " is complete.");
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("[PDF] Exception " + exception + " opening URL " + string);
            exception.printStackTrace();
        }
        if (this.visible) {
            this.download.setVisible(false);
        }
        return this.tempURLFile;
    }
}

