/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.images;

import com.sun.imageio.plugins.jpeg.JPEGImageWriter;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.TIFFEncodeParam;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import javax.media.jai.JAI;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.exception.PdfException;
import org.jpedal.fonts.FontMappings;
import org.jpedal.io.JAIHelper;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.utils.LogWriter;
import org.w3c.dom.Element;

public class ConvertPagesToImages {
    boolean isTransparent = false;
    private String user_dir = System.getProperty("user.dir");
    private float pageScaling = 1.33f;
    public static boolean outputMessages = false;
    String output_dir = null;
    String separator = System.getProperty("file.separator");
    PdfDecoder decode_pdf = null;
    private String format = "png";
    private String[] ocr = new String[]{"TeleForm"};
    private boolean useHiresImage = false;
    private String test_file = "/mnt/shared/sample_pdfs/general/World Factbook.pdf";
    public static boolean isTest = false;
    public static boolean orderReversed = false;
    private int scaling = 100;
    private String password = null;
    private float JPEGcompression = -1.0f;

    public ConvertPagesToImages(String[] stringArray) {
        String string = this.setParams(stringArray);
        File file = new File(string);
        if (!file.exists()) {
            System.out.println("File " + file + " not found");
            System.out.println("May need full path");
            return;
        }
        this.extraction(string, this.output_dir);
    }

    private void extraction(String string, String string2) {
        String string3 = System.getProperty("org.jpedal.hires");
        if (Commands.hires || string3 != null) {
            this.useHiresImage = true;
        }
        this.output_dir = string2;
        if (!this.user_dir.endsWith(this.separator)) {
            this.user_dir = this.user_dir + this.separator;
        }
        if (string.toLowerCase().endsWith(".pdf")) {
            if (!isTest && string2 == null) {
                string2 = this.user_dir + "thumbnails" + this.separator;
            }
            this.decodeFile(string, string2);
        } else {
            String[] stringArray = null;
            if (!string.endsWith(this.separator)) {
                string = string + this.separator;
            }
            try {
                File file = new File(string);
                if (!file.isDirectory()) {
                    System.err.println(string + " is not a directory. Exiting program");
                } else {
                    stringArray = file.list();
                }
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception trying to access file " + exception.getMessage());
            }
            if (stringArray != null) {
                for (String string4 : stringArray) {
                    if (!string4.toLowerCase().endsWith(".pdf")) continue;
                    if (outputMessages) {
                        System.out.println(string + string4);
                    }
                    this.decodeFile(string + string4, string2);
                }
            }
        }
        if (outputMessages) {
            System.out.println("Thumbnails created");
        }
    }

    private void decodeFile(String string, String string2) {
        String string3 = "demo";
        int n = string.lastIndexOf(this.separator);
        if (n == -1) {
            n = string.lastIndexOf(47);
        }
        if (n != -1) {
            string3 = string.substring(n + 1, string.length() - 4);
        } else if (!isTest && string.toLowerCase().endsWith(".pdf")) {
            string3 = string.substring(0, string.length() - 4);
        }
        if (string2 == null) {
            string2 = this.user_dir + "thumbnails" + this.separator;
        }
        try {
            this.decode_pdf = new PdfDecoder(true);
            if (!isTest) {
                FontMappings.setFontReplacements();
            }
            if (isTest) {
                this.pageScaling = 1.0f;
            }
            this.decode_pdf.setExtractionMode(0, this.pageScaling);
            if (outputMessages) {
                System.out.println("Opening file :" + string);
            }
            if (this.password != null) {
                this.decode_pdf.openPdfFile(string, this.password);
            } else {
                this.decode_pdf.openPdfFile(string);
            }
        }
        catch (Exception exception) {
            System.err.println("8.Exception " + exception + " in pdf code in " + string);
        }
        if (this.decode_pdf.isEncrypted() && !this.decode_pdf.isFileViewable()) {
            if (!isTest) {
                throw new RuntimeException("Wrong password password used=>" + this.password + '<');
            }
        } else {
            if (this.decode_pdf.isEncrypted() && !this.decode_pdf.isPasswordSupplied() && !this.decode_pdf.isExtractionAllowed()) {
                throw new RuntimeException("Extraction not allowed");
            }
            String string4 = System.getProperty("org.jpedal.separation");
            if (string4 != null) {
                Object[] objectArray = new Object[]{7, "", Boolean.FALSE};
                if (string4.equals("all")) {
                    objectArray = new Object[]{2, "image_and_shapes", Boolean.FALSE, 18, "image_without_shapes", Boolean.FALSE, 1, "text_and_shapes", Boolean.TRUE, 7, "all", Boolean.FALSE, 17, "text_without_shapes", Boolean.TRUE};
                }
                int n2 = objectArray.length;
                for (int i = 0; i < n2; i += 3) {
                    this.decode_pdf.setRenderMode((Integer)objectArray[i]);
                    this.extractPageAsImage(string, string2, string3 + '_' + objectArray[i + 1], (Boolean)objectArray[i + 2]);
                }
            } else {
                this.extractPageAsImage(string, string2, string3, this.isTransparent);
            }
        }
        this.decode_pdf.closePdfFile();
    }

    private void extractPageAsImage(String string, String string2, String string3, boolean bl) {
        boolean bl2;
        String string4;
        File file = new File(string2);
        if (!file.exists()) {
            file.mkdirs();
        }
        boolean bl3 = (string4 = System.getProperty("org.jpedal.multipage_tiff")) != null && string4.toLowerCase().equals("true");
        String string5 = System.getProperty("org.jpedal.compression_jpeg");
        if (string5 != null) {
            try {
                this.JPEGcompression = Float.parseFloat(string5);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (this.JPEGcompression < 0.0f || this.JPEGcompression > 1.0f) {
                throw new RuntimeException("Invalid value for JPEG compression - must be between 0 and 1");
            }
        }
        String string6 = System.getProperty("org.jpedal.compress_tiff");
        String string7 = System.getProperty("org.jpedal.jpeg_dpi");
        boolean bl4 = bl2 = string6 != null && string6.toLowerCase().equals("true");
        if (JAIHelper.isJAIused()) {
            JAIHelper.confirmJAIOnClasspath();
        }
        int n = 1;
        int n2 = this.decode_pdf.getPageCount();
        if (n2 > 10 && isTest) {
            n2 = 10;
        }
        if (outputMessages) {
            System.out.println("Thumbnails will be in  " + string2);
        }
        try {
            BufferedImage[] bufferedImageArray = new BufferedImage[1 + (n2 - n)];
            if (orderReversed) {
                for (int i = n2; i >= n; --i) {
                    this.getPage(string2, string3, bl, bl3, string5, string7, bl2, n, n2, bufferedImageArray, i);
                }
            } else {
                for (int i = n; i < n2 + 1; ++i) {
                    this.getPage(string2, string3, bl, bl3, string5, string7, bl2, n, n2, bufferedImageArray, i);
                }
            }
        }
        catch (Exception exception) {
            this.decode_pdf.closePdfFile();
            throw new RuntimeException("Exception " + exception.getMessage() + " with thumbnails on File=" + string);
        }
    }

    private void getPage(String string, String string2, boolean bl, boolean bl2, String string3, String string4, boolean bl3, int n, int n2, BufferedImage[] bufferedImageArray, int n3) throws PdfException, IOException, FileNotFoundException {
        int n4;
        int n5;
        Object object;
        Image object2;
        if (outputMessages) {
            System.out.println("Page " + n3);
        }
        String string5 = String.valueOf(n3);
        String string6 = String.valueOf(n2);
        int n6 = string6.length() - string5.length();
        for (int i = 0; i < n6; ++i) {
            string5 = '0' + string5;
        }
        String string7 = bl2 ? string2 : string2 + "_page_" + string5;
        PdfFileInformation pdfFileInformation = this.decode_pdf.getFileInformationData();
        String[] stringArray = pdfFileInformation.getFieldValues();
        String[] stringArray2 = PdfFileInformation.getFieldNames();
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!stringArray2[i].equals("Creator")) continue;
            for (String object32 : this.ocr) {
                if (!stringArray[i].equals(object32)) continue;
                this.decode_pdf.setRenderMode(2);
            }
        }
        if (!bl) {
            object2 = this.decode_pdf.getPageAsImage(n3);
        } else {
            object2 = this.decode_pdf.getPageAsTransparentImage(n3);
            if (object2 != null && this.format.toLowerCase().startsWith("jp")) {
                object = object2;
                n5 = ((BufferedImage)object).getWidth();
                n4 = ((BufferedImage)object).getHeight();
                object2 = new BufferedImage(n5, n4, 1);
                Graphics2D graphics2D = ((BufferedImage)object2).createGraphics();
                graphics2D.setPaint(Color.WHITE);
                graphics2D.fillRect(0, 0, n5, n4);
                graphics2D.drawImage((Image)object, 0, 0, null);
            }
        }
        object = this.decode_pdf.getPageInfo(1);
        int n7 = n4 = object != null ? 1 : 0;
        while (object != null && object.hasNext()) {
            n5 = (Integer)object.next();
            if (n5 == 1568372915 || n5 == 391471749) continue;
            n4 = 0;
        }
        if (n4 != 0) {
            BufferedImage bufferedImage = new BufferedImage(((BufferedImage)object2).getWidth(), ((BufferedImage)object2).getHeight(), 10);
            bufferedImage.getGraphics().drawImage(object2, 0, 0, null);
            object2 = bufferedImage;
        }
        if (bl2) {
            bufferedImageArray[n3 - n] = object2;
        }
        if (object2 == null) {
            if (outputMessages && !isTest) {
                System.out.println("No image generated - are you using client mode?");
            }
        } else {
            String string8;
            Graphics2D graphics2D;
            Object object3;
            int n8;
            String string9 = System.getProperty("maxDimension");
            int n9 = -1;
            if (string9 != null) {
                n9 = Integer.parseInt(string9);
            }
            if (this.scaling != 100 || n9 != -1) {
                int n10 = ((BufferedImage)object2).getWidth() * this.scaling / 100;
                n8 = ((BufferedImage)object2).getHeight() * this.scaling / 100;
                if (n9 != -1 && (n10 > n9 || n8 > n9)) {
                    if (n10 > n8) {
                        n10 = n9;
                        object3 = object2.getScaledInstance(n10, -1, 4);
                    } else {
                        n8 = n9;
                        object3 = object2.getScaledInstance(-1, n8, 4);
                    }
                } else {
                    object3 = object2.getScaledInstance(n10, -1, 4);
                }
                object2 = this.format.toLowerCase().startsWith("jp") ? new BufferedImage(((Image)object3).getWidth(null), ((Image)object3).getHeight(null), 1) : new BufferedImage(((Image)object3).getWidth(null), ((Image)object3).getHeight(null), 2);
                graphics2D = ((BufferedImage)object2).createGraphics();
                graphics2D.drawImage((Image)object3, 0, 0, null);
            }
            if ((string8 = System.getProperty("org.jpedal.imageType")) != null) {
                if (ConvertPagesToImages.isNumber(string8)) {
                    n8 = Integer.parseInt(string8);
                    if (n8 > -1 && n8 < 14) {
                        object3 = new BufferedImage(((BufferedImage)object2).getWidth(), ((BufferedImage)object2).getHeight(), n8);
                        graphics2D = ((BufferedImage)object3).createGraphics();
                        graphics2D.drawImage(object2, null, null);
                        object2 = object3;
                    } else {
                        System.err.println("Image Type is not valid. Value should be a digit between 0 - 13 based on the BufferedImage TYPE variables.");
                    }
                } else {
                    System.err.println("Image Type provided is not an Integer. Value should be a digit between 0 - 13 based on the BufferedImage TYPE variables.");
                }
            }
            if (JAIHelper.isJAIused() && this.format.startsWith("tif")) {
                TIFFEncodeParam tIFFEncodeParam = new TIFFEncodeParam();
                if (bl3) {
                    tIFFEncodeParam.setCompression(32773);
                }
                if (!bl2) {
                    object3 = new BufferedOutputStream(new FileOutputStream(string + string5 + string7 + ".tif"));
                    JAI.create((String)"encode", (RenderedImage)((Object)object2), (Object)object3, (Object)"TIFF", (Object)tIFFEncodeParam);
                } else if (bl2 && n3 == n2) {
                    object3 = new BufferedOutputStream(new FileOutputStream(string + string7 + ".tif"));
                    graphics2D = ImageCodec.createImageEncoder((String)"TIFF", (OutputStream)object3, (ImageEncodeParam)tIFFEncodeParam);
                    ArrayList<BufferedImage> arrayList = new ArrayList<BufferedImage>();
                    arrayList.addAll(Arrays.asList(bufferedImageArray).subList(1, bufferedImageArray.length));
                    tIFFEncodeParam.setExtraImages(arrayList.iterator());
                    graphics2D.encode(bufferedImageArray[0]);
                    ((OutputStream)object3).close();
                }
            } else if ((string4 != null || string3 != null) && this.format.startsWith("jp") && JAIHelper.isJAIused()) {
                ConvertPagesToImages.saveAsJPEG(string4, (BufferedImage)object2, this.JPEGcompression, new BufferedOutputStream(new FileOutputStream(string + string5 + string7 + '.' + this.format)));
            } else {
                this.decode_pdf.getObjectStore().saveStoredImage(string + string5 + string7, (BufferedImage)object2, true, false, this.format);
            }
        }
        this.decode_pdf.flushObjectValues(true);
    }

    public static void main(String[] stringArray) {
        boolean bl;
        System.out.println("Simple demo to extract images from a page");
        int n = stringArray.length;
        boolean bl2 = bl = n > 4 || n == 0;
        if (bl) {
            if (n > 0) {
                System.out.println("too many arguments entered - run with no values to see defaults");
                String string = "";
                for (String string2 : stringArray) {
                    string = string + string2 + '\n';
                }
                System.out.println("you entered:\n" + string + "as the arguments");
            }
            ConvertPagesToImages.showCommandLineValues();
        }
        new ConvertPagesToImages(stringArray);
    }

    private String setParams(String[] stringArray) {
        String string = this.test_file;
        int n = stringArray.length;
        if (n == 0) {
            ConvertPagesToImages.showCommandLineValues();
        } else if (n == 1) {
            string = stringArray[0];
        } else if (n < 6) {
            string = stringArray[0];
            for (int i = 1; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                boolean bl = ConvertPagesToImages.isNumber(string2);
                if (bl) {
                    try {
                        this.scaling = Integer.parseInt(string2);
                        continue;
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(string2 + " is not an integer");
                    }
                }
                String string3 = string2.toLowerCase();
                if (string3.equals("jpg") || string3.equals("jpeg")) {
                    this.format = "jpg";
                    continue;
                }
                if (string3.equals("tif") || string3.equals("tiff")) {
                    this.format = "tif";
                    continue;
                }
                if (string3.equals("png")) {
                    this.format = "png";
                    continue;
                }
                if (string2.endsWith("/") || string2.endsWith("\\")) {
                    this.output_dir = string2;
                    continue;
                }
                this.password = string2;
            }
        }
        return string;
    }

    static void showCommandLineValues() {
        System.out.println("Example can take 1-5 parameters");
        System.out.println("Value 1 is the file name or directory of PDF files to process");
        System.out.println("4 optional values of:-\nimage type (jpeg,tiff,png), \nscaling (100 = full size), \npassword for protected file (or null) can also be added ,\noutput path (must end with / or \\ character)");
        System.exit(0);
    }

    private static boolean isNumber(String string) {
        boolean bl = true;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!(c < '0' | c > '9')) continue;
            bl = false;
            i = n;
        }
        return bl;
    }

    public String getOutputDir() {
        return this.output_dir;
    }

    private static void saveAsJPEG(String string, BufferedImage bufferedImage, float f, BufferedOutputStream bufferedOutputStream) throws IOException {
        JPEGImageWriter jPEGImageWriter = (JPEGImageWriter)ImageIO.getImageWritersBySuffix("jpeg").next();
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(bufferedOutputStream);
        jPEGImageWriter.setOutput(imageOutputStream);
        IIOMetadata iIOMetadata = jPEGImageWriter.getDefaultImageMetadata(new ImageTypeSpecifier(bufferedImage), null);
        if (string != null) {
            int n = 96;
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Element element = (Element)iIOMetadata.getAsTree("javax_imageio_jpeg_image_1.0");
            Element element2 = (Element)element.getElementsByTagName("app0JFIF").item(0);
            element2.setAttribute("Xdensity", Integer.toString(n));
            element2.setAttribute("Ydensity", Integer.toString(n));
        }
        if (f >= 0.0f && f <= 1.0f) {
            JPEGImageWriteParam jPEGImageWriteParam = (JPEGImageWriteParam)jPEGImageWriter.getDefaultWriteParam();
            jPEGImageWriteParam.setCompressionMode(2);
            jPEGImageWriteParam.setCompressionQuality(f);
        }
        jPEGImageWriter.write(iIOMetadata, new IIOImage(bufferedImage, null, null), null);
        imageOutputStream.close();
        jPEGImageWriter.dispose();
    }
}

