/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.examples.handlers.DefaultImageHelper;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ImageHelper;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.JAIHelper;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;
import org.w3c.dom.NodeList;

public class GenericColorSpace
implements Cloneable,
Serializable {
    public ImageHelper images = new DefaultImageHelper();
    boolean isConverted = false;
    private String intent = null;
    float[] rawValues;
    Map patterns;
    float[][] CTM;
    float[] inputs;
    private int size = 0;
    float c = -1.0f;
    float y = -1.0f;
    float m = -1.0f;
    float k = -1.0f;
    float[] W;
    float[] G;
    float[] Ma;
    float[] R;
    public static ColorSpace rgbCS;
    public static final String cb = "<color ";
    public static final String ce = "</color>";
    int value = 1785221209;
    static ColorConvertOp CSToRGB;
    ColorSpace cs;
    PdfPaint currentColor = new PdfColor(0, 0, 0);
    static ColorModel rgbModel;
    public static ICC_Profile ICCProfileForRGB;
    public static boolean fasterPNG;
    boolean failed = false;
    int alternative = -1;
    private PdfObject decodeParms = null;
    private boolean hasYCCKimages = false;
    private Object[] cache;
    boolean isPrinting = false;
    int r;
    int g;
    int b;
    byte[] IndexedColorMap = null;
    String pantoneName = null;
    int componentCount = 3;
    GraphicsState gs;
    int pageWidth;
    int pageHeight;
    private static final int multiplier = 100000;

    public void setPrinting(boolean bl) {
        this.isPrinting = bl;
    }

    protected static void initCMYKColorspace() throws PdfException {
        try {
            Object object;
            if (ICCProfileForRGB == null) {
                rgbModel = new ComponentColorModel(rgbCS, new int[]{8, 8, 8}, false, false, 1, 0);
            } else {
                int n = rgbCS.getNumComponents();
                object = new int[n];
                for (int i = 0; i < n; ++i) {
                    object[i] = 8;
                }
                rgbModel = new ComponentColorModel(rgbCS, (int[])object, false, false, 1, 0);
            }
            ICC_Profile iCC_Profile = ICC_Profile.getInstance(GenericColorSpace.class.getResourceAsStream("/org/jpedal/res/cmm/cmyk.icm"));
            object = new ICC_ColorSpace(iCC_Profile);
            CSToRGB = new ColorConvertOp((ColorSpace)object, rgbCS, ColorSpaces.hints);
        }
        catch (Exception exception) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception " + exception.getMessage() + " initialising color components");
            }
            throw new PdfException("[PDF] Unable to create CMYK colorspace. Check cmyk.icm in jar file");
        }
    }

    public void reset() {
        this.currentColor = new PdfColor(0, 0, 0);
    }

    public boolean isInvalid() {
        return this.failed;
    }

    public int getIndexSize() {
        return this.size;
    }

    public PdfPaint getColor() {
        return this.currentColor;
    }

    public ColorSpace getColorSpace() {
        return this.cs;
    }

    GenericColorSpace() {
        this.cs = rgbCS;
    }

    protected void setAlternateColorSpace(int n) {
        this.alternative = n;
    }

    public int getAlternateColorSpace() {
        return this.alternative;
    }

    public void restoreColorStatus() {
        this.currentColor = new PdfColor(this.r, this.g, this.b);
    }

    public Object clone() {
        Object object;
        try {
            object = super.clone();
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to clone object");
        }
        return object;
    }

    protected final BufferedImage nonRGBJPEGToRGBImage(byte[] byArray, int n, int n2, float[] fArray, int n3, int n4) {
        BufferedImage bufferedImage;
        block33: {
            ImageInputStream imageInputStream;
            ImageReader imageReader;
            ByteArrayInputStream byteArrayInputStream;
            block31: {
                boolean bl = false;
                bufferedImage = null;
                byteArrayInputStream = null;
                imageReader = null;
                imageInputStream = null;
                try {
                    int n5;
                    Object object;
                    block32: {
                        int n6;
                        Object object2;
                        int n7;
                        block30: {
                            if (CSToRGB == null) {
                                GenericColorSpace.initCMYKColorspace();
                            }
                            CSToRGB = new ColorConvertOp(this.cs, rgbCS, ColorSpaces.hints);
                            byteArrayInputStream = new ByteArrayInputStream(byArray);
                            n7 = GenericColorSpace.getJPEGTransform(byArray);
                            try {
                                object = ImageIO.getImageReadersByFormatName("JPEG");
                                while (object.hasNext() && !(imageReader = (object2 = object.next())).canReadRaster()) {
                                }
                            }
                            catch (Exception exception) {
                                if (LogWriter.isOutput()) {
                                    LogWriter.writeLog("Unable to find JAI jars on classpath");
                                }
                                return null;
                            }
                            ImageIO.setUseCache(false);
                            imageInputStream = ImageIO.createImageInputStream(byteArrayInputStream);
                            imageReader.setInput(imageInputStream, true);
                            object = imageReader.readRaster(0, null);
                            if (fArray != null) {
                                if (fArray.length == 6 && fArray[0] == 1.0f && fArray[1] == 0.0f && fArray[2] == 1.0f && fArray[3] == 0.0f && fArray[4] == 1.0f && fArray[5] == 0.0f || fArray.length > 2 && fArray[0] == 1.0f && fArray[1] == 0.0f) {
                                    object2 = ((Raster)object).getDataBuffer();
                                    n5 = ((DataBuffer)object2).getSize();
                                    for (n6 = 0; n6 < n5; ++n6) {
                                        ((DataBuffer)object2).setElem(n6, 255 - ((DataBuffer)object2).getElem(n6));
                                    }
                                } else if (fArray.length == 6 && fArray[0] == 0.0f && fArray[1] == 1.0f && fArray[2] == 0.0f && fArray[3] == 1.0f && fArray[4] == 0.0f && fArray[5] == 1.0f || fArray == null || fArray.length > 0) {
                                    // empty if block
                                }
                            }
                            if (this.cs.getNumComponents() == 4) {
                                bl = true;
                                try {
                                    if (n7 == 2) {
                                        this.hasYCCKimages = true;
                                        bufferedImage = ColorSpaceConvertor.iccConvertCMYKImageToRGB(((DataBufferByte)((Raster)object).getDataBuffer()).getData(), n, n2);
                                        break block30;
                                    }
                                    object = GenericColorSpace.cleanupRaster((Raster)object, n3, n4, 4);
                                    n = ((Raster)object).getWidth();
                                    n2 = ((Raster)object).getHeight();
                                    object2 = rgbModel.createCompatibleWritableRaster(n, n2);
                                    CSToRGB.filter((Raster)object, (WritableRaster)object2);
                                    bufferedImage = new BufferedImage(n, n2, 1);
                                    bufferedImage.setData((Raster)object2);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                    if (LogWriter.isOutput()) {
                                        LogWriter.writeLog("Problem with JPEG conversion");
                                    }
                                    break block30;
                                }
                            }
                            if (n7 != 0) {
                                bufferedImage = imageReader.read(0);
                                bufferedImage = GenericColorSpace.cleanupImage(bufferedImage, n3, n4, this.value);
                                bl = true;
                            }
                        }
                        if (bl) break block31;
                        if (n7 == 4) {
                            object = GenericColorSpace.cleanupRaster((Raster)object, n3, n4, 4);
                            n5 = ((Raster)object).getWidth();
                            n6 = ((Raster)object).getHeight();
                            object2 = rgbModel.createCompatibleWritableRaster(n5, n6);
                            CSToRGB.filter((Raster)object, (WritableRaster)object2);
                            bufferedImage = new BufferedImage(n5, n6, 1);
                            bufferedImage.setData((Raster)object2);
                            break block31;
                        }
                        n5 = 0;
                        try {
                            IIOMetadata iIOMetadata = imageReader.getImageMetadata(0);
                            String string = iIOMetadata.getNativeMetadataFormatName();
                            IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)iIOMetadata.getAsTree(string);
                            NodeList nodeList = iIOMetadataNode.getElementsByTagName("app14Adobe");
                            if (nodeList.getLength() > 0) {
                                n5 = 1;
                            }
                        }
                        catch (Exception exception) {
                            if (!LogWriter.isOutput()) break block32;
                            LogWriter.writeLog("[PDF] Unable to read metadata on Jpeg " + exception);
                        }
                    }
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("COLOR_ID_YCbCr image");
                    }
                    bufferedImage = n5 != 0 ? ImageIO.read(new ByteArrayInputStream(byArray)) : ColorSpaceConvertor.algorithmicConvertYCbCrToRGB(((DataBufferByte)((Raster)object).getDataBuffer()).getData(), n, n2);
                    bufferedImage = GenericColorSpace.cleanupImage(bufferedImage, n3, n4, this.value);
                    bufferedImage = ColorSpaceConvertor.convertToRGB(bufferedImage);
                }
                catch (Exception exception) {
                    bufferedImage = null;
                    exception.printStackTrace();
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Couldn't read JPEG, not even raster: " + exception);
                    }
                }
                catch (Error error) {
                    if (imageReader != null) {
                        imageReader.dispose();
                    }
                    if (imageInputStream == null) break block31;
                    try {
                        imageInputStream.flush();
                    }
                    catch (IOException iOException) {
                        if (!LogWriter.isOutput()) break block31;
                        LogWriter.writeLog("Exception: " + iOException.getMessage());
                    }
                }
            }
            try {
                byteArrayInputStream.close();
                imageReader.dispose();
                imageInputStream.close();
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block33;
                LogWriter.writeLog("Problem closing  " + exception);
            }
        }
        return bufferedImage;
    }

    protected static BufferedImage cleanupImage(BufferedImage bufferedImage, int n, int n2, int n3) {
        try {
            int n4 = bufferedImage.getType();
            if (GenericColorSpace.getSampling(bufferedImage.getWidth(), bufferedImage.getHeight(), n, n2) <= 1 || n4 == 0) {
                return bufferedImage;
            }
            if (n4 == 5) {
                return GenericColorSpace.cleanupBGRImage(bufferedImage, n, n2);
            }
            if (n4 == 5) {
                bufferedImage = ColorSpaceConvertor.convertToRGB(bufferedImage);
            }
            Raster raster = GenericColorSpace.cleanupRaster(bufferedImage.getData(), n, n2, bufferedImage.getColorModel().getNumColorComponents());
            bufferedImage = new BufferedImage(raster.getWidth(), raster.getHeight(), bufferedImage.getType());
            bufferedImage.setData(raster);
            return bufferedImage;
        }
        catch (Error error) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("[PDF] Error in cleanupImage " + error);
            }
            return bufferedImage;
        }
    }

    private static int getSampling(int n, int n2, int n3, int n4) {
        int n5 = 1;
        int n6 = n;
        if (n3 > 0 && n4 > 0) {
            int n7;
            int n8 = n4 << 2;
            int n9 = n3 << 2;
            for (int i = n2; n6 > n9 && i > n8; n6 >>= 1, i >>= 1) {
                n5 <<= 1;
            }
            int n10 = n / n3;
            if (n10 < 1) {
                n10 = 1;
            }
            if ((n7 = n2 / n4) < 1) {
                n7 = 1;
            }
            if ((n5 = n10) > n7) {
                n5 = n7;
            }
        }
        return n5;
    }

    protected static Raster cleanupRaster(Raster raster, int n, int n2, int n3) {
        block25: {
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            String string = System.getProperty("org.jpedal.avoidCleanupRaster");
            if (string != null && string.toLowerCase().contains("true")) {
                return raster;
            }
            byte[] byArray = null;
            int[] nArray = null;
            DataBuffer dataBuffer = raster.getDataBuffer();
            boolean bl = dataBuffer instanceof DataBufferInt;
            if (bl) {
                nArray = ((DataBufferInt)dataBuffer).getData();
            } else {
                n11 = raster.getNumBands();
                if (n11 == n3) {
                    byArray = ((DataBufferByte)dataBuffer).getData();
                } else if (n11 == 1) {
                    byte[] byArray2 = ((DataBufferByte)raster.getDataBuffer()).getData();
                    n10 = byArray2.length;
                    n9 = n10 * n3;
                    n8 = 0;
                    n7 = 0;
                    byArray = new byte[n9];
                    do {
                        for (n6 = 0; n6 < n3; ++n6) {
                            byArray[n8] = byArray2[n7];
                            ++n8;
                        }
                    } while (++n7 < n10);
                }
            }
            n11 = 1;
            int n12 = raster.getWidth();
            n10 = raster.getHeight();
            n9 = n12;
            if (n > 0 && n2 > 0) {
                n7 = n2 << 2;
                n6 = n << 2;
                for (n8 = n10; n9 > n6 && n8 > n7; n9 >>= 1, n8 >>= 1) {
                    n11 <<= 1;
                }
                n5 = n12 / n;
                if (n5 < 1) {
                    n5 = 1;
                }
                if ((n4 = n10 / n2) < 1) {
                    n4 = 1;
                }
                if ((n11 = n5) > n4) {
                    n11 = n4;
                }
            }
            if (n11 > 1) {
                n9 = n12 / n11;
                n8 = n10 / n11;
                int n13 = n12;
                try {
                    int n14;
                    byte[] byArray3 = new byte[n9 * n8 * n3];
                    if (!bl) {
                        n13 = n12 * n3;
                    }
                    for (n6 = 0; n6 < n8; ++n6) {
                        for (n7 = 0; n7 < n9; ++n7) {
                            int n15 = n11;
                            n14 = n11;
                            int n16 = n12 - n7;
                            int n17 = n10 - n6;
                            if (n15 > n16) {
                                n15 = n16;
                            }
                            if (n14 > n17) {
                                n14 = n17;
                            }
                            for (int i = 0; i < n3; ++i) {
                                int n18 = 0;
                                int n19 = 0;
                                for (n4 = 0; n4 < n14; ++n4) {
                                    for (n5 = 0; n5 < n15; ++n5) {
                                        n18 = !bl ? (n18 += byArray[(n4 + n6 * n11) * n13 + (n7 * n11 * n3 + n5 * n3 + i)] & 0xFF) : (n18 += nArray[(n4 + n6 * n11) * n13 + n7 * n11 + n5] >> 8 * (2 - i) & 0xFF);
                                        ++n19;
                                    }
                                }
                                if (n19 <= 0) continue;
                                byArray3[i + n7 * n3 + n9 * n6 * n3] = (byte)(n18 / n19);
                            }
                        }
                    }
                    int[] nArray2 = new int[n3];
                    for (n14 = 0; n14 < n3; ++n14) {
                        nArray2[n14] = n14;
                    }
                    raster = Raster.createInterleavedRaster(new DataBufferByte(byArray3, byArray3.length), n9, n8, n9 * n3, n3, nArray2, null);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (!LogWriter.isOutput()) break block25;
                    LogWriter.writeLog("Problem with Image");
                }
            }
        }
        return raster;
    }

    private static BufferedImage cleanupBGRImage(BufferedImage bufferedImage, int n, int n2) {
        block26: {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            if (System.getProperty("java.version").startsWith("1.5")) {
                return bufferedImage;
            }
            Raster raster = bufferedImage.getData();
            int n11 = bufferedImage.getColorModel().getNumColorComponents();
            byte[] byArray = null;
            int[] nArray = null;
            DataBuffer dataBuffer = raster.getDataBuffer();
            boolean bl = dataBuffer instanceof DataBufferInt;
            if (bl) {
                nArray = ((DataBufferInt)dataBuffer).getData();
            } else {
                n10 = raster.getNumBands();
                if (n10 == n11) {
                    byArray = ((DataBufferByte)dataBuffer).getData();
                } else if (n10 == 1) {
                    byte[] byArray2 = ((DataBufferByte)raster.getDataBuffer()).getData();
                    n9 = byArray2.length;
                    n8 = n9 * n11;
                    n7 = 0;
                    n6 = 0;
                    byArray = new byte[n8];
                    do {
                        for (n5 = 0; n5 < n11; ++n5) {
                            byArray[n7] = byArray2[n6];
                            ++n7;
                        }
                    } while (++n6 < n9);
                }
            }
            n10 = 1;
            int n12 = raster.getWidth();
            n9 = raster.getHeight();
            n8 = n12;
            if (n > 0 && n2 > 0) {
                n6 = n2 << 2;
                n5 = n << 2;
                for (n7 = n9; n8 > n5 && n7 > n6; n8 >>= 1, n7 >>= 1) {
                    n10 <<= 1;
                }
                n4 = n12 / n;
                if (n4 < 1) {
                    n4 = 1;
                }
                if ((n3 = n9 / n2) < 1) {
                    n3 = 1;
                }
                if ((n10 = n4) > n3) {
                    n10 = n3;
                }
            }
            if (n10 > 1) {
                WritableRaster writableRaster = (WritableRaster)raster;
                n8 = n12 / n10;
                n7 = n9 / n10;
                int n13 = n12;
                try {
                    int[] nArray2 = new int[n11];
                    if (!bl) {
                        n13 = n12 * n11;
                    }
                    for (n4 = 0; n4 < n7; ++n4) {
                        for (n5 = 0; n5 < n8; ++n5) {
                            int n14 = n10;
                            int n15 = n10;
                            int n16 = n12 - n5;
                            int n17 = n9 - n4;
                            if (n14 > n16) {
                                n14 = n16;
                            }
                            if (n15 > n17) {
                                n15 = n17;
                            }
                            for (int i = 0; i < n11; ++i) {
                                int n18 = 0;
                                int n19 = 0;
                                for (int j = 0; j < n15; ++j) {
                                    for (n3 = 0; n3 < n14; ++n3) {
                                        n18 = !bl ? (n18 += byArray[(j + n4 * n10) * n13 + (n5 * n10 * n11 + n3 * n11 + i)] & 0xFF) : (n18 += nArray[(j + n4 * n10) * n13 + n5 * n10 + n3] >> 8 * (2 - i) & 0xFF);
                                        ++n19;
                                    }
                                }
                                if (n19 <= 0) continue;
                                if (i == 0) {
                                    nArray2[2] = n18 / n19;
                                    continue;
                                }
                                if (i == 2) {
                                    nArray2[0] = n18 / n19;
                                    continue;
                                }
                                nArray2[i] = n18 / n19;
                            }
                            writableRaster.setPixels(n5, n4, 1, 1, nArray2);
                        }
                    }
                    bufferedImage = new BufferedImage(n8, n7, bufferedImage.getType());
                    bufferedImage.setData(writableRaster);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (!LogWriter.isOutput()) break block26;
                    LogWriter.writeLog("Problem with Image");
                }
            }
        }
        return bufferedImage;
    }

    private static int getJPEGTransform(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        int n3 = byArray.length - 2;
        block0: while (n2 < n3) {
            int n4 = byArray[n2 + 1] & 0xFF;
            n2 += 2;
            if (n4 == 1 || 208 <= n4 && n4 <= 218) continue;
            if (n4 == 218) {
                n2 = n2 + ((byArray[n2] & 0xFF) << 8) + (byArray[n2 + 1] & 0xFF);
                while (true) {
                    if (n2 < n3 && ((byArray[n2] & 0xFF) != 255 || byArray[n2 + 1] == 0)) {
                        ++n2;
                        continue;
                    }
                    int n5 = byArray[n2 + 1] & 0xFF;
                    if (208 > n5 || n5 > 215) continue block0;
                    n2 += 2;
                }
            }
            if (n4 == 238 && byArray[n2 + 2] == 65 && byArray[n2 + 3] == 100 && byArray[n2 + 4] == 111 && byArray[n2 + 5] == 98 && byArray[n2 + 6] == 101) {
                n = byArray[n2 + 13] & 0xFF;
                break;
            }
            n2 = n2 + ((byArray[n2] & 0xFF) << 8) + (byArray[n2 + 1] & 0xFF);
        }
        return n;
    }

    public void setIndex(byte[] byArray, int n) {
        this.IndexedColorMap = byArray;
        this.size = n;
    }

    public void setIndex(String string, String string2, int n) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        this.size = n;
        if (string.startsWith("(\\")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "(\\)");
            while (stringTokenizer.hasMoreTokens()) {
                n2 = Integer.parseInt(stringTokenizer.nextToken(), 8);
                String string3 = Integer.toHexString(n2);
                if (string3.length() < 2) {
                    stringBuilder.append('0');
                }
                stringBuilder.append(string3);
            }
        } else if (!string.startsWith("(")) {
            if (string.startsWith("<")) {
                string = string.substring(1, string.length() - 1).trim();
            }
            stringBuilder = new StringBuilder(string);
        }
        int n3 = 1;
        if (string2.contains("RGB") | string2.contains("ICC")) {
            n3 = 3;
        } else if (string2.contains("CMYK")) {
            n3 = 4;
        }
        this.IndexedColorMap = new byte[(n + 1) * n3];
        stringBuilder = Strip.stripAllSpaces(stringBuilder);
        for (n2 = 0; n2 < n + 1; ++n2) {
            for (int i = 0; i < n3; ++i) {
                int n4 = n2 * n3 * 2 + i * 2;
                int n5 = Integer.parseInt(stringBuilder.substring(n4, n4 + 2), 16);
                this.IndexedColorMap[n2 * n3 + i] = (byte)n5;
            }
        }
    }

    protected int getIndexedColorComponent(int n) {
        int n2 = 255;
        if (this.IndexedColorMap != null && (n2 = this.IndexedColorMap[n]) < 0) {
            n2 = 256 + n2;
        }
        return n2;
    }

    public byte[] getIndexedMap() {
        if (this.IndexedColorMap == null) {
            return null;
        }
        int n = this.IndexedColorMap.length;
        byte[] byArray = new byte[n];
        System.arraycopy(this.IndexedColorMap, 0, byArray, 0, n);
        return byArray;
    }

    public void setColor(String[] stringArray, int n) {
    }

    public void setColor(float[] fArray, int n) {
    }

    public BufferedImage JPEGToRGBImage(byte[] byArray, int n, int n2, float[] fArray, int n3, int n4, boolean bl, PdfObject pdfObject) {
        BufferedImage bufferedImage;
        block11: {
            ByteArrayInputStream byteArrayInputStream = null;
            try {
                bufferedImage = this.images.read(byArray);
                if (bufferedImage != null && !fasterPNG) {
                    if (this.value != 1568372915) {
                        bufferedImage = GenericColorSpace.cleanupImage(bufferedImage, n3, n4, this.value);
                    }
                    if (this.value != 1568372915) {
                        bufferedImage = ColorSpaceConvertor.convertToRGB(bufferedImage);
                    }
                }
            }
            catch (Exception exception) {
                bufferedImage = null;
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Problem reading JPEG: " + exception);
                }
                exception.printStackTrace();
            }
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (IOException iOException) {
                    if (!LogWriter.isOutput()) break block11;
                    LogWriter.writeLog("Exception: " + iOException.getMessage());
                }
            }
        }
        if (bl && this.value == 1568372915) {
            DataBufferByte dataBufferByte = (DataBufferByte)bufferedImage.getRaster().getDataBuffer();
            byte[] byArray2 = dataBufferByte.getData();
            for (int i = 0; i < byArray2.length; ++i) {
                byArray2[i] = (byte)(byArray2[i] ^ 0xFF);
            }
            bufferedImage.setData(Raster.createRaster(bufferedImage.getSampleModel(), new DataBufferByte(byArray2, byArray2.length), null));
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BufferedImage JPEG2000ToRGBImage(byte[] byArray, int n, int n2, float[] fArray, int n3, int n4) throws PdfException {
        ImageReader imageReader;
        ByteArrayInputStream byteArrayInputStream;
        BufferedImage bufferedImage = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            imageReader = ImageIO.getImageReadersByFormatName("JPEG2000").next();
        }
        catch (Exception exception) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Problem reading JPEG 2000: " + exception);
            }
            String string = "Exception " + exception + " with JPeg 2000 Image from iir = (ImageReader)ImageIO.getImageReadersByFormatName(\"JPEG2000\").next();";
            if (JAIHelper.isJAIused()) throw new PdfException(string);
            string = "JPeg 2000 Images and JAI not setup.\nYou need both JAI and imageio.jar on classpath, and the VM parameter -Dorg.jpedal.jai=true switch turned on";
            throw new PdfException(string);
        }
        if (imageReader == null) {
            return null;
        }
        try {
            Object object;
            block14: {
                ImageInputStream imageInputStream = ImageIO.createImageInputStream(byteArrayInputStream);
                try {
                    Object var13_18;
                    block13: {
                        try {
                            imageReader.setInput(imageInputStream, true);
                            bufferedImage = imageReader.read(0);
                            object = this.getIndexedMap();
                            if (object == null || this.value != 1785221209) break block13;
                            byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                            bufferedImage = ColorSpaceConvertor.convertIndexedToFlat(8, n, n2, byArray, object, false, false);
                        }
                        catch (Exception exception) {
                            if (LogWriter.isOutput()) {
                                LogWriter.writeLog("Problem reading JPEG 2000: " + exception);
                            }
                            exception.printStackTrace();
                            bufferedImage = null;
                            var13_18 = null;
                            imageReader.dispose();
                            imageInputStream.close();
                            byteArrayInputStream.close();
                            break block14;
                        }
                    }
                    var13_18 = null;
                    imageReader.dispose();
                }
                catch (Throwable throwable) {
                    Object var13_19 = null;
                    imageReader.dispose();
                    imageInputStream.close();
                    byteArrayInputStream.close();
                    throw throwable;
                }
                imageInputStream.close();
                byteArrayInputStream.close();
            }
            if (bufferedImage == null) return bufferedImage;
            if ((bufferedImage = GenericColorSpace.cleanupImage(bufferedImage, n3, n4, this.value)).getType() != 13) return ColorSpaceConvertor.convertToRGB(bufferedImage);
            object = bufferedImage;
            int n5 = bufferedImage.getWidth();
            int n6 = bufferedImage.getHeight();
            bufferedImage = new BufferedImage(n5, n6, 1);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setPaint(Color.WHITE);
            graphics2D.fillRect(0, 0, n5, n6);
            graphics2D.drawImage((Image)object, 0, 0, null);
            return ColorSpaceConvertor.convertToRGB(bufferedImage);
        }
        catch (Exception exception) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Problem reading JPEG 2000: " + exception);
            }
            String string = "Exception " + exception + " with JPeg 2000 Image";
            if (JAIHelper.isJAIused()) throw new PdfException(string);
            string = "JPeg 2000 Images and JAI not setup.\nYou need both JAI and imageio.jar on classpath, and the VM parameter -Dorg.jpedal.jai=true switch turned on";
            throw new PdfException(string);
        }
        catch (Error error) {
            error.printStackTrace();
            if (!LogWriter.isOutput()) throw new PdfException("JPeg 2000 Images need both JAI (imageio.jar) on classpath, and the VM parameter -Dorg.jpedal.jai=true switch turned on");
            LogWriter.writeLog("Problem reading JPEG 2000: " + error);
            throw new PdfException("JPeg 2000 Images need both JAI (imageio.jar) on classpath, and the VM parameter -Dorg.jpedal.jai=true switch turned on");
        }
    }

    public BufferedImage dataToRGB(byte[] byArray, int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Raster raster = ColorSpaceConvertor.createInterleavedRaster(byArray, n, n2);
        bufferedImage.setData(raster);
        return bufferedImage;
    }

    public static BufferedImage BufferedImageToRGBImage(BufferedImage bufferedImage) {
        return bufferedImage;
    }

    public int getID() {
        return this.value;
    }

    public final void setCIEValues(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, float[] fArray5) {
        this.cs = ColorSpace.getInstance(1001);
        this.G = fArray5;
        this.Ma = fArray4;
        this.W = fArray;
        this.R = fArray3;
    }

    protected final byte[] convert4Index(byte[] byArray) {
        return this.convertIndex(byArray, 4);
    }

    private byte[] convertIndex(byte[] byArray, int n) {
        block7: {
            if (n == 4 && this.value == 1498837125) {
                int n2 = byArray.length;
                byte[] byArray2 = new byte[n2 * 3 / 4];
                int n3 = 0;
                for (int i = 0; i < n2; i += 4) {
                    int n4;
                    float[] fArray = new float[4];
                    for (n4 = 0; n4 < 4; ++n4) {
                        fArray[n4] = (float)(byArray[i + n4] & 0xFF) / 255.0f;
                    }
                    this.setColor(fArray, 4);
                    n4 = this.currentColor.getRGB();
                    byArray2[n3] = (byte)(n4 >> 16 & 0xFF);
                    byArray2[n3 + 1] = (byte)(n4 >> 8 & 0xFF);
                    byArray2[n3 + 2] = (byte)(n4 & 0xFF);
                    n3 += 3;
                    if (n2 - 4 - i >= 4) continue;
                    i = n2;
                }
                return byArray2;
            }
            try {
                int n5 = byArray.length / n;
                int n6 = 1;
                DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
                int[] nArray = new int[]{0, 1, 2, 3};
                int[] nArray2 = new int[]{0, 1, 2};
                int[] nArray3 = n == 4 ? nArray : nArray2;
                WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n5, n6, n5 * n, n, nArray3, null);
                if (CSToRGB == null) {
                    GenericColorSpace.initCMYKColorspace();
                }
                CSToRGB = new ColorConvertOp(this.cs, rgbCS, ColorSpaces.hints);
                WritableRaster writableRaster2 = rgbModel.createCompatibleWritableRaster(n5, n6);
                CSToRGB.filter(writableRaster, writableRaster2);
                DataBuffer dataBuffer = writableRaster2.getDataBuffer();
                int n7 = n5 * n6 * 3;
                byArray = new byte[n7];
                for (int i = 0; i < n7; ++i) {
                    byArray[i] = (byte)dataBuffer.getElem(i);
                }
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block7;
                LogWriter.writeLog("Exception  " + exception + " converting colorspace");
            }
        }
        return byArray;
    }

    public byte[] convertIndexToRGB(byte[] byArray) {
        return byArray;
    }

    public String getXMLColorToken() {
        String string;
        if (this.c == -1.0f) {
            if (this.currentColor instanceof Color) {
                Color color = (Color)((Object)this.currentColor);
                float f = (float)(255 - color.getRed()) / 255.0f;
                float f2 = (float)(255 - color.getGreen()) / 255.0f;
                float f3 = (float)(255 - color.getBlue()) / 255.0f;
                float f4 = f;
                if (f4 < f2) {
                    f4 = f2;
                }
                if (f4 < f3) {
                    f4 = f3;
                }
                string = this.pantoneName == null ? "<color C='" + f + "' M='" + f2 + "' Y='" + f3 + "' K='" + f4 + "' >" : "<color C='" + f + "' M='" + f2 + "' Y='" + f3 + "' K='" + f4 + "' pantoneName='" + this.pantoneName + "' >";
            } else {
                string = "<color type='shading'>";
            }
        } else {
            string = this.pantoneName == null ? "<color C='" + this.c + "' M='" + this.m + "' Y='" + this.y + "' K='" + this.k + "' >" : "<color C='" + this.c + "' M='" + this.m + "' Y='" + this.y + "' K='" + this.k + "' pantoneName='" + this.pantoneName + "' >";
        }
        return string;
    }

    public void setPattern(Map map, int n, int n2, float[][] fArray) {
        this.patterns = map;
        this.pageWidth = n;
        this.pageHeight = n2;
        this.CTM = fArray;
    }

    public void setColor(PdfPaint pdfPaint) {
        this.currentColor = pdfPaint;
    }

    public void setColorIsTransparent() {
        this.currentColor = new PdfColor(255, 0, 0, 0);
    }

    public int getColorComponentCount() {
        return this.componentCount;
    }

    public void setGS(GraphicsState graphicsState) {
        this.gs = graphicsState;
    }

    public void setIntent(String string) {
        this.intent = string;
    }

    public String getIntent() {
        return this.intent;
    }

    public float[] getRawValues() {
        return this.rawValues;
    }

    public boolean isImageYCCK() {
        return this.hasYCCKimages;
    }

    public void setDecodeParms(PdfObject pdfObject) {
        this.decodeParms = pdfObject;
    }

    public boolean isIndexConverted() {
        return this.isConverted;
    }

    public Color getCachedShadingColor(float f) {
        if (this.cache == null) {
            return null;
        }
        return (Color)this.cache[(int)(f * 100000.0f)];
    }

    public void setShadedColor(float f, Color color) {
        if (this.cache == null) {
            this.cache = new Object[100001];
        }
        this.cache[(int)(f * 100000.0f)] = color;
    }

    public void clearCache() {
    }

    public static ColorSpace getColorSpaceInstance() {
        ColorSpace colorSpace;
        block3: {
            colorSpace = ColorSpace.getInstance(1000);
            String string = System.getProperty("org.jpedal.RGBprofile");
            if (string != null) {
                try {
                    colorSpace = new ICC_ColorSpace(ICC_Profile.getInstance(new FileInputStream(string)));
                    System.out.println("use " + string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (!LogWriter.isOutput()) break block3;
                    LogWriter.writeLog("[PDF] Problem " + exception.getMessage() + " with ICC data ");
                }
            }
        }
        return colorSpace;
    }

    static {
        block4: {
            CSToRGB = null;
            rgbModel = null;
            ICCProfileForRGB = null;
            fasterPNG = false;
            String string = System.getProperty("org.jpedal.fasterPNG");
            fasterPNG = string != null && string.toLowerCase().equals("true");
            String string2 = System.getProperty("org.jpedal.RGBprofile");
            if (string2 != null) {
                try {
                    ICCProfileForRGB = ICC_Profile.getInstance(new FileInputStream(string2));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("[PDF] Problem " + exception.getMessage() + " with ICC data ");
                    }
                    if (ICCProfileForRGB != null) break block4;
                    throw new RuntimeException("Problem wth RGB profile " + string2 + ' ' + exception.getMessage());
                }
            }
        }
        rgbCS = ICCProfileForRGB != null ? new ICC_ColorSpace(ICCProfileForRGB) : ColorSpace.getInstance(1000);
    }
}

