/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.acroforms.xfa;

import com.idrsolutions.pdf.acroforms.xfa.XFAFormObject;
import com.idrsolutions.pdf.acroforms.xfa.XFAPageContent;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.acroforms.utils.ConvertToString;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.FormStream;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.StreamObject;
import org.jpedal.utils.LogWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XFAFormStream
extends FormStream {
    private static boolean showBug = false;
    private static final boolean debugXFAstream = false;
    private static final boolean showXFAdata = false;
    private boolean calledOnce = false;
    private Node config;
    private Node dataset;
    private Node template;
    private XFAFormObject formObject;
    private LinkedList xfaFormList;
    private String pagenum;
    private int contentX;
    private int contentH;
    private Map valueMap = new HashMap();
    private static final int UNKNOWN = -1;
    private static final int PAGESET = 1;
    private static final int PAGEAREA = 2;
    private static final int SUBFORM = 3;
    private static final int BREAK = 4;
    private static final int BREAKBEFORE = 5;
    private static final int BREAKAFTER = 6;
    public HashMap<Integer, XFAPageContent> pageMap = new HashMap();
    public ArrayList<Node> pageAreaList = new ArrayList();

    public XFAFormStream(PdfObject pdfObject, PdfObjectReader pdfObjectReader) {
        this.currentPdfFile = pdfObjectReader;
        this.readXFA(pdfObject);
    }

    private Node toDocument(int n, byte[] byArray) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            document = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(byArray));
        }
        catch (Exception exception) {
            document = null;
        }
        return document;
    }

    public Node getXFA(int n) {
        Node node = null;
        switch (n) {
            case 1043741046: {
                node = this.config;
                break;
            }
            case 1130793076: {
                node = this.dataset;
                break;
            }
            case 1013350773: {
                node = this.template;
                break;
            }
            case 1031041382: {
                break;
            }
            case 1951819392: {
                break;
            }
            case 1701743524: {
                break;
            }
            case 1026916721: {
                break;
            }
            case 0x363436: {
                break;
            }
            case 2088075366: {
                break;
            }
        }
        return node;
    }

    private void readXFA(PdfObject pdfObject) {
        PdfObject pdfObject2 = null;
        PdfArrayIterator pdfArrayIterator = null;
        pdfObject2 = pdfObject.getDictionary(2627089);
        if (pdfObject2 == null && (pdfArrayIterator = pdfObject.getMixedArray(2627089)) != null && pdfArrayIterator.getTokenCount() == 0) {
            pdfArrayIterator = null;
        }
        if (pdfObject2 != null) {
            byte[] byArray = pdfObject2.getDecodedStream();
            this.template = XFAFormStream.xmlToNode(1013350773, byArray);
        } else {
            StreamObject streamObject = null;
            int n = 0;
            while (pdfArrayIterator != null && pdfArrayIterator.hasMoreTokens()) {
                n = pdfArrayIterator.getNextValueAsConstant(true);
                streamObject = new StreamObject(pdfArrayIterator.getNextValueAsString(true));
                this.currentPdfFile.readObject(streamObject);
                byte[] byArray = streamObject.getDecodedStream();
                switch (n) {
                    case 1043741046: {
                        this.config = this.toDocument(1043741046, byArray);
                        break;
                    }
                    case 1130793076: {
                        this.dataset = this.toDocument(1130793076, byArray);
                        break;
                    }
                    case 1013350773: {
                        this.template = this.toDocument(1013350773, byArray);
                        break;
                    }
                    case 1031041382: {
                        break;
                    }
                    case 1951819392: {
                        break;
                    }
                    case 1701743524: {
                        break;
                    }
                    case 1026916721: {
                        break;
                    }
                    case 0x363436: {
                        break;
                    }
                    case 2088075366: {
                        break;
                    }
                }
            }
        }
    }

    private static Node xmlToNode(int n, byte[] byArray) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            document = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(byArray));
        }
        catch (Exception exception) {
            document = null;
        }
        switch (n) {
            case 1043741046: {
                NodeList nodeList = document.getElementsByTagName("config");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element = (Element)nodeList.item(i);
                    String string = element.getAttribute("xmlns");
                    if (string.length() <= 0) continue;
                    return element;
                }
                break;
            }
            case 1130793076: {
                NodeList nodeList = document.getElementsByTagName("xfa:datasets");
                Element element = (Element)nodeList.item(0);
                return element;
            }
            case 1013350773: {
                NodeList nodeList = document.getElementsByTagName("template");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element = (Element)nodeList.item(i);
                    String string = element.getAttribute("xmlns:xfa");
                    if (string.length() <= 0) continue;
                    return element;
                }
                break;
            }
        }
        return null;
    }

    public boolean hasXFADataSet() {
        return this.dataset != null;
    }

    public FormObject[] createAppearanceString(FormObject[] formObjectArray) {
        if (this.calledOnce) {
            return null;
        }
        this.calledOnce = true;
        return this.oldXFA(formObjectArray);
    }

    private FormObject[] oldXFA(FormObject[] formObjectArray) {
        int n;
        this.xfaFormList = new LinkedList();
        this.parseStream();
        int n2 = this.xfaFormList.size();
        int n3 = formObjectArray.length < n2 ? formObjectArray.length : n2;
        FormObject[][] formObjectArray2 = new FormObject[n3][2];
        for (n = 0; n < n3; ++n) {
            String string;
            formObjectArray2[n][0] = formObjectArray[n];
            if (formObjectArray[n] != null) {
                string = formObjectArray[n].getTextStreamValue(36);
                if (string != null) {
                    int n4 = string.lastIndexOf("[0]");
                    int n5 = string.lastIndexOf(46, n4 - 1);
                    if (n5 != -1) {
                        string = n4 != -1 ? string.substring(n5 + 1, n4) : string.substring(n5 + 1);
                    } else if (n4 != -1) {
                        string = string.substring(0, n4);
                    }
                }
            } else {
                string = null;
            }
            Object object = this.xfaFormList.iterator();
            while (object.hasNext()) {
                String string2;
                Object e = object.next();
                XFAFormObject xFAFormObject = (XFAFormObject)e;
                if (xFAFormObject == null || !(string2 = xFAFormObject.getTextStreamValue(36)).equals(string)) continue;
                formObjectArray2[n][1] = xFAFormObject;
                break;
            }
            if (string == null || (object = (String)this.valueMap.get(string.toLowerCase())) == null) continue;
            formObjectArray2[n][0].setTextValue((String)object);
        }
        formObjectArray = new FormObject[n3];
        for (n = 0; n < n3; ++n) {
            if (formObjectArray2[n][1] != null) {
                formObjectArray2[n][1].overwriteWith(formObjectArray2[n][0]);
                formObjectArray[n] = formObjectArray2[n][1];
                if (showBug) {
                    System.out.println("wrong " + n);
                }
            } else {
                formObjectArray[n] = formObjectArray2[n][0];
                if (showBug) {
                    System.out.println("correct " + n);
                }
            }
            if (!showBug) continue;
            System.out.println(n + " " + formObjectArray[n].getTextString());
        }
        return formObjectArray;
    }

    protected void parseStream() {
        ArrayList arrayList = new ArrayList();
        XFAFormStream.parseNode(this.template, arrayList);
        this.setupTemplate(arrayList.iterator());
        ArrayList arrayList2 = new ArrayList();
        XFAFormStream.parseNode(this.dataset, arrayList2);
        this.setupDataSet(arrayList2.iterator());
    }

    private void setupDataSet(Iterator iterator) {
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            String string = node.getNodeName();
            if (!string.equals("xfa:data")) continue;
            this.data(node, iterator);
        }
    }

    private void data(Node node, Iterator iterator) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            NodeList nodeList2 = node2.getChildNodes();
            if (nodeList2.getLength() <= 0) continue;
            Node node3 = nodeList2.item(0);
            nodeList2 = node3.getChildNodes();
            String string = node3.getNodeName();
            if (nodeList2.getLength() <= 0) continue;
            Node node4 = nodeList2.item(0);
            this.valueMap.put(string.toLowerCase(), node4.getNodeValue());
        }
    }

    private void nextFormObject() {
        if (this.formObject != null) {
            this.xfaFormList.add(this.formObject);
        }
        this.formObject = new XFAFormObject();
    }

    private static void parseNode(Node node, ArrayList arrayList) {
        arrayList.add(node);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            XFAFormStream.parseNode(nodeList.item(i), arrayList);
        }
    }

    private void setupTemplate(Iterator iterator) {
        while (iterator.hasNext()) {
            Node node;
            NamedNodeMap namedNodeMap;
            Node node2 = (Node)iterator.next();
            String string = node2.getNodeName();
            if (string.equals("field")) {
                this.field(node2, iterator);
                continue;
            }
            if (string.equals("pageArea")) {
                namedNodeMap = node2.getAttributes();
                node = namedNodeMap.getNamedItem("id");
                this.pagenum = node.getNodeValue();
                this.pagenum = this.pagenum.substring(this.pagenum.indexOf("Page") + 4);
                continue;
            }
            if (string.equals("contentArea")) {
                namedNodeMap = node2.getAttributes();
                if (namedNodeMap == null) continue;
                node = namedNodeMap.getNamedItem("x");
                if (node != null) {
                    this.contentX = XFAFormStream.resolveMeasurementToPoints(node.getNodeValue());
                }
                if ((node = namedNodeMap.getNamedItem("h")) == null) continue;
                this.contentH = XFAFormStream.resolveMeasurementToPoints(node.getNodeValue());
                continue;
            }
            if (!string.equals("#document") && !string.equals("templateDesigner")) continue;
        }
        this.nextFormObject();
    }

    private static int resolveMeasurementToPoints(String string) {
        int n = 0;
        if (string.endsWith("pt")) {
            n = new Double(string.substring(0, string.indexOf("pt"))).intValue();
        } else if (string.endsWith("in")) {
            n = (int)(72.0 * Double.parseDouble(string.substring(0, string.indexOf("in"))));
        } else if (string.endsWith("cm")) {
            n = (int)(28.35 * Double.parseDouble(string.substring(0, string.indexOf("cm"))));
        } else if (string.endsWith("mm")) {
            n = (int)(2.835 * Double.parseDouble(string.substring(0, string.indexOf("mm"))));
        } else {
            LogWriter.writeFormLog("UNIMPLEMENTED type of y size=" + string, false);
        }
        return n;
    }

    private void field(Node node, Iterator iterator) {
        Node node2;
        this.nextFormObject();
        this.formObject.setPageNumber(this.pagenum);
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            node2 = namedNodeMap.getNamedItem("x");
            if (node2 != null) {
                this.formObject.setX(this.contentX + XFAFormStream.resolveMeasurementToPoints(node2.getNodeValue()));
            }
            if ((node2 = namedNodeMap.getNamedItem("y")) != null) {
                this.formObject.setY(this.contentH - XFAFormStream.resolveMeasurementToPoints(node2.getNodeValue()));
            }
            if ((node2 = namedNodeMap.getNamedItem("w")) != null) {
                this.formObject.setWidth(XFAFormStream.resolveMeasurementToPoints(node2.getNodeValue()));
            }
            if ((node2 = namedNodeMap.getNamedItem("h")) != null) {
                this.formObject.setHeight(XFAFormStream.resolveMeasurementToPoints(node2.getNodeValue()));
            }
            if ((node2 = namedNodeMap.getNamedItem("name")) != null) {
                this.formObject.setTextStreamValue(36, node2.getNodeValue());
            } else {
                this.formObject.setTextStreamValue(36, "");
            }
        }
        node2 = null;
        while (iterator.hasNext() && !(node2 = (Node)iterator.next()).getNodeName().equals("ui")) {
            node2 = null;
        }
        if (node2 == null) {
            System.out.println("ERROR ERROR  ERROR no ui in field=" + ConvertToString.convertDocumentToString(node));
        } else {
            Node node3 = null;
            String string = null;
            while (iterator.hasNext()) {
                node3 = (Node)iterator.next();
                string = node3.getNodeName();
                if (string.equals("checkButton")) {
                    this.checkButton(node3, iterator);
                    continue;
                }
                if (string.equals("button")) {
                    this.button(node3, iterator);
                    continue;
                }
                if (string.equals("choiceList")) {
                    this.choiceList(node3, iterator);
                    continue;
                }
                if (string.equals("textEdit")) {
                    this.textEdit(node3, iterator);
                    continue;
                }
                LogWriter.writeFormLog("node not implemented nodename=" + string, false);
            }
        }
    }

    private void textEdit(Node node, Iterator iterator) {
        this.formObject.setType(9288, true);
        this.formObject.setFlag(13, true);
        this.formObject.setFlag(14, false);
        String string = node.getNodeName();
        String string2 = node.getNodeValue();
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            // empty if block
        }
        while (iterator.hasNext()) {
            Object object;
            Node node2 = (Node)iterator.next();
            String string3 = node2.getNodeName();
            if (string3.equals("templateDesigner")) continue;
            if (string3.equals("field")) {
                this.field(node2, iterator);
                continue;
            }
            if (string3.equals("value") || string3.equals("caption")) continue;
            if (string3.equals("text")) {
                if (!iterator.hasNext()) continue;
                object = (Node)iterator.next();
                continue;
            }
            if (string3.equals("para")) {
                object = node2.getAttributes();
                Node node3 = object.getNamedItem("hAlign");
                if (node3 != null) {
                    this.formObject.setHorizontalAlign(node3.getNodeValue());
                }
                if ((node3 = object.getNamedItem("vAlign")) == null) continue;
                this.formObject.setVerticalAllign(node3.getNodeValue());
                continue;
            }
            if (string3.equals("font")) {
                object = node2.getAttributes().getNamedItem("typeface");
                if (object == null) continue;
            }
            if (string3.equals("edge")) {
                object = node2.getAttributes().getNamedItem("stroke");
                if (object == null) continue;
                this.formObject.setBorderStroke(object.getNodeValue());
                continue;
            }
            if (string3.equals("border") || string3.equals("margin") || string3.equals("proto")) continue;
            LogWriter.writeFormLog("node name not implemented in textEdit name=" + string3, false);
        }
    }

    private void choiceList(Node node, Iterator iterator) {
        Node node2;
        this.formObject.setType(4920, true);
        this.formObject.setFlag(18, false);
        String string = node.getNodeName();
        String string2 = node.getNodeValue();
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null && (node2 = namedNodeMap.getNamedItem("open")) != null) {
            this.formObject.setChoiceOpening(node2.getNodeValue());
        }
        while (iterator.hasNext()) {
            Object object;
            node2 = (Node)iterator.next();
            String string3 = node2.getNodeName();
            if (string3.equals("templateDesigner")) continue;
            if (string3.equals("field")) {
                this.field(node2, iterator);
                continue;
            }
            if (string3.equals("value") || string3.equals("caption") || string3.equals("items")) continue;
            if (string3.equals("text")) {
                if (!iterator.hasNext()) continue;
                object = (Node)iterator.next();
                this.formObject.setTextValue(object.getNodeValue());
                continue;
            }
            if (string3.equals("para")) {
                object = node2.getAttributes();
                Node node3 = object.getNamedItem("hAlign");
                if (node3 != null) {
                    this.formObject.setHorizontalAlign(node3.getNodeValue());
                }
                if ((node3 = object.getNamedItem("vAlign")) == null) continue;
                this.formObject.setVerticalAllign(node3.getNodeValue());
                continue;
            }
            if (string3.equals("font")) {
                object = node2.getAttributes().getNamedItem("typeface");
                if (object == null) continue;
            }
            if (string3.equals("edge")) {
                object = node2.getAttributes().getNamedItem("stroke");
                if (object == null) continue;
                this.formObject.setBorderStroke(object.getNodeValue());
                continue;
            }
            if (string3.equals("border") || string3.equals("margin") || string3.equals("draw") || string3.equals("rectangle")) continue;
            LogWriter.writeFormLog("node name not implemented in choiceList name=" + string3, false);
        }
    }

    private void button(Node node, Iterator iterator) {
        this.formObject.setType(1197118, true);
        this.formObject.setFlag(17, true);
        String string = node.getNodeName();
        String string2 = node.getNodeValue();
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            // empty if block
        }
        while (iterator.hasNext()) {
            Node node2;
            Object object;
            Node node3 = (Node)iterator.next();
            String string3 = node3.getNodeName();
            if (string3.equals("templateDesigner")) continue;
            if (string3.equals("field")) {
                this.field(node3, iterator);
                continue;
            }
            if (string3.equals("edge")) {
                object = node3.getAttributes().getNamedItem("stroke");
                if (object == null) continue;
                this.formObject.setBorderStroke(object.getNodeValue());
                continue;
            }
            if (string3.equals("caption") || string3.equals("value")) continue;
            if (string3.equals("text")) {
                if (!iterator.hasNext()) continue;
                object = (Node)iterator.next();
                this.formObject.setNormalCaption(object.getNodeValue());
                continue;
            }
            if (string3.equals("para")) {
                object = node3.getAttributes();
                node2 = object.getNamedItem("hAlign");
                if (node2 != null) {
                    this.formObject.setHorizontalAlign(node2.getNodeValue());
                }
                if ((node2 = object.getNamedItem("vAlign")) == null) continue;
                this.formObject.setVerticalAllign(node2.getNodeValue());
                continue;
            }
            if (string3.equals("font")) {
                object = node3.getAttributes().getNamedItem("typeface");
                if (object == null) continue;
            }
            if (string3.equals("border") || string3.equals("fill")) continue;
            if (string3.equals("color")) {
                object = node3.getAttributes().getNamedItem("value");
                if (object == null) continue;
                this.formObject.setBackgroundColor(object.getNodeValue());
                continue;
            }
            if (string3.equals("bind")) continue;
            if (string3.equals("event")) {
                object = node3.getAttributes().getNamedItem("activity");
                this.formObject.setEventAction(object.getNodeValue());
                continue;
            }
            if (string3.equals("script")) {
                object = node3.getAttributes();
                if (object != null && (node2 = object.getNamedItem("contentType")) != null) {
                    this.formObject.setScriptType(node2.getNodeValue());
                }
                if (!iterator.hasNext() || (node2 = (Node)iterator.next()) == null) continue;
                this.formObject.setScript(node2.getNodeValue());
                continue;
            }
            if (string3.equals("submit")) {
                Node node4;
                Node node5;
                object = node3.getAttributes();
                node2 = object.getNamedItem("format");
                if (node2 != null) {
                    this.formObject.setSubmitFormat(node2.getNodeValue());
                }
                if ((node5 = object.getNamedItem("target")) != null) {
                    this.formObject.setSubmitURL(node5.getNodeValue());
                }
                if ((node4 = object.getNamedItem("textEncoding")) == null) continue;
                this.formObject.setSubmitTextEncoding(node4.getNodeValue());
                continue;
            }
            LogWriter.writeFormLog("node name not implemented in button name=" + string3, false);
        }
    }

    private void checkButton(Node node, Iterator iterator) {
        this.formObject.setType(4920, true);
        this.formObject.setFlag(18, true);
        String string = node.getNodeName();
        String string2 = node.getNodeValue();
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            // empty if block
        }
        while (iterator.hasNext()) {
            Object object;
            Node node2 = (Node)iterator.next();
            String string3 = node2.getNodeName();
            if (string3.equals("templateDesigner")) continue;
            if (string3.equals("field")) {
                this.field(node2, iterator);
                continue;
            }
            if (string3.equals("value") || string3.equals("caption")) continue;
            if (string3.equals("text")) {
                if (!iterator.hasNext()) continue;
                object = (Node)iterator.next();
                this.formObject.setTextValue(object.getNodeValue());
                continue;
            }
            if (string3.equals("integer")) {
                if (!iterator.hasNext()) continue;
                object = (Node)iterator.next();
                this.formObject.setIntegerValue(object.getNodeValue());
                continue;
            }
            if (string3.equals("para")) {
                object = node2.getAttributes();
                Node node3 = object.getNamedItem("hAlign");
                if (node3 != null) {
                    this.formObject.setHorizontalAlign(node3.getNodeValue());
                }
                if ((node3 = object.getNamedItem("vAlign")) == null) continue;
                this.formObject.setVerticalAllign(node3.getNodeValue());
                continue;
            }
            if (string3.equals("font")) {
                object = node2.getAttributes().getNamedItem("typeface");
                if (object == null) continue;
            }
            if (string3.equals("edge")) {
                object = node2.getAttributes().getNamedItem("stroke");
                if (object == null) continue;
                this.formObject.setBorderStroke(object.getNodeValue());
                continue;
            }
            if (string3.equals("border") || string3.equals("fill") || string3.equals("margin") || string3.equals("event") || string3.equals("items") || string3.equals("exclGroup") || string3.equals("proto")) continue;
            LogWriter.writeFormLog("node name not implemented in checkbutton name=" + string3, false);
        }
    }

    public Map getRefToFormArray() {
        return null;
    }

    private Node getPageAreaNodeById(String string) {
        for (Node node : this.pageAreaList) {
            Node node2 = node.getAttributes().getNamedItem("id");
            if (node2 == null || !node2.getNodeValue().equals(string)) continue;
            return node;
        }
        return null;
    }

    private Node getPageAreaNodeByName(String string) {
        for (Node node : this.pageAreaList) {
            Node node2 = node.getAttributes().getNamedItem("name");
            if (node2 == null || !node2.getNodeValue().equals(string)) continue;
            return node;
        }
        return null;
    }

    private void allocatePagesWithContents(Node node, int n) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            int n2 = this.getNodeType(node2.getNodeName());
            if (n2 == 1) {
                int n3;
                NodeList nodeList2 = node2.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    if (this.getNodeType(nodeList2.item(j).getNodeName()) != 2) continue;
                    this.pageAreaList.add(nodeList2.item(j));
                }
                NodeList nodeList3 = node2.getParentNode().getChildNodes();
                ArrayList<Node> arrayList = new ArrayList<Node>();
                for (n3 = 0; n3 < nodeList3.getLength(); ++n3) {
                    if (this.getNodeType(nodeList3.item(n3).getNodeName()) != 3) continue;
                    arrayList.add(nodeList3.item(n3));
                }
                if (this.pageAreaList.size() == 1 && arrayList.size() == 1) {
                    XFAPageContent xFAPageContent = new XFAPageContent();
                    xFAPageContent.setPageAreaNode(this.pageAreaList.get(0));
                    xFAPageContent.getNodeList().add((Node)arrayList.get(0));
                    this.pageMap.put(1, xFAPageContent);
                    break;
                }
                n3 = 1;
                Node node3 = this.pageAreaList.get(0);
                block3: for (int j = 0; j < arrayList.size(); ++j) {
                    Node node4 = (Node)arrayList.get(j);
                    NodeList nodeList4 = node4.getChildNodes();
                    for (int k = 0; k < nodeList4.getLength(); ++k) {
                        Node node5;
                        Object object;
                        Node node6 = nodeList4.item(k);
                        int n4 = this.getNodeType(node6.getNodeName());
                        if (n4 == 4) {
                            object = node6.getAttributes().getNamedItem("beforeTarget");
                            node5 = node6.getAttributes().getNamedItem("startNew");
                            if (node5 != null) {
                                if (this.pageAreaList.size() > 1 && n3 < this.pageAreaList.size()) {
                                    ++n3;
                                }
                                if (object != null) {
                                    node3 = this.getPageAreaNodeById(object.getNodeValue());
                                    break;
                                }
                                node3 = this.pageAreaList.get(n3 - 1);
                                break;
                            }
                            if (this.pageMap.get(n3) == null) break;
                            ++n3;
                            break;
                        }
                        if (n4 == 5) {
                            object = node6.getAttributes().getNamedItem("target");
                            node5 = node6.getAttributes().getNamedItem("startNew");
                            if (node5 != null) {
                                if (this.pageAreaList.size() > 1 && n3 < this.pageAreaList.size()) {
                                    ++n3;
                                }
                                if (object != null) {
                                    node3 = this.getPageAreaNodeById(object.getNodeValue());
                                    break;
                                }
                                node3 = this.pageAreaList.get(n3 - 1);
                                break;
                            }
                            if (this.pageMap.get(n3) == null) break;
                            ++n3;
                            break;
                        }
                        if (n4 != 6) continue;
                        if (node6.getAttributes().getNamedItem("startNew") == null) continue block3;
                        if (this.pageMap.get(n3) == null) {
                            object = new XFAPageContent();
                            ((XFAPageContent)object).setPageAreaNode(node3);
                            ((XFAPageContent)object).getNodeList().add(node4);
                            this.pageMap.put(n3, (XFAPageContent)object);
                        } else {
                            this.pageMap.get(n3).getNodeList().add(node4);
                        }
                        ++n3;
                        continue block3;
                    }
                    if (this.pageMap.get(n3) == null) {
                        XFAPageContent xFAPageContent = new XFAPageContent();
                        xFAPageContent.setPageAreaNode(node3);
                        xFAPageContent.getNodeList().add(node4);
                        this.pageMap.put(n3, xFAPageContent);
                        continue;
                    }
                    this.pageMap.get(n3).getNodeList().add(node4);
                }
                break;
            }
            this.allocatePagesWithContents(node2, n++);
        }
    }

    private int getNodeType(String string) {
        int n = -1;
        String string2 = string.toLowerCase();
        if (string2.equals("pagearea")) {
            n = 2;
        } else if (string2.equals("subform")) {
            n = 3;
        } else if (string2.equals("pageset")) {
            n = 1;
        } else if (string2.equals("break")) {
            n = 4;
        } else if (string2.equals("breakbefore")) {
            n = 5;
        } else if (string2.equals("breakafter")) {
            n = 6;
        }
        return n;
    }
}

