/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.request.mustache;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.MustacheException;
import com.github.mustachejava.MustacheFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tiles.request.Request;
import org.apache.tiles.request.render.CannotRenderException;
import org.apache.tiles.request.render.Renderer;

public class MustacheRenderer
implements Renderer {
    private static final ThreadLocal<Request> REQUEST_HOLDER = new ThreadLocal();
    private final MustacheFactory factory;
    private Pattern acceptPattern;

    public MustacheRenderer() {
        this.factory = new DefaultMustacheFactory();
    }

    public MustacheRenderer(MustacheFactory factory) {
        this.factory = factory;
    }

    public void render(String path, Request request) throws IOException {
        if (path == null) {
            throw new CannotRenderException("Cannot dispatch a null path");
        }
        try {
            REQUEST_HOLDER.set(request);
            this.factory.compile(path).execute(request.getWriter(), this.buildScope(request));
            REQUEST_HOLDER.remove();
        }
        catch (MustacheException ex) {
            throw new IOException("failed to MustacheRenderer.render(" + path + ",request)", ex);
        }
    }

    public static Request getThreadLocalRequest() {
        return REQUEST_HOLDER.get();
    }

    protected Map<String, Object> buildScope(Request request) {
        HashMap<String, Object> scope = new HashMap<String, Object>();
        List availableScopes = request.getAvailableScopes();
        for (int i = availableScopes.size() - 1; i >= 0; --i) {
            scope.putAll(request.getContext((String)availableScopes.get(i)));
        }
        return scope;
    }

    public boolean isRenderable(String path, Request request) {
        if (path == null) {
            return false;
        }
        if (this.acceptPattern != null) {
            Matcher matcher = this.acceptPattern.matcher(path);
            return matcher.matches();
        }
        return true;
    }

    public final void setAcceptPattern(Pattern acceptPattern) {
        this.acceptPattern = acceptPattern;
    }
}

