CREATE DATABASE  IF NOT EXISTS `zhituyunke` /*!40100 DEFAULT CHARACTER SET utf8 */;
USE `zhituyunke`;

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `log_study`
--

DROP TABLE IF EXISTS `log_study`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `log_study` (
  `log_id` varchar(64) NOT NULL,
  `item_id` bigint(20) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `visit_key` varchar(128) DEFAULT NULL,
  `visit_date` datetime DEFAULT NULL,
  `visit_time` bigint(20) DEFAULT NULL,
  `visit_year` int(11) DEFAULT NULL,
  `visit_month` int(11) DEFAULT NULL,
  `visit_day` int(11) DEFAULT NULL,
  `ip_address` varchar(32) DEFAULT NULL,
  `country` varchar(128) DEFAULT NULL,
  `province` varchar(128) DEFAULT NULL,
  `city` varchar(128) DEFAULT NULL,
  `os_name` varchar(16) DEFAULT NULL,
  `os_ver` varchar(16) DEFAULT NULL,
  `display_size` varchar(16) DEFAULT NULL,
  `display_color` varchar(16) DEFAULT NULL,
  `browser_name` varchar(16) DEFAULT NULL,
  `browser_ver` varchar(16) DEFAULT NULL,
  `cookie_supported` varchar(16) DEFAULT NULL,
  `js_supported` varchar(16) DEFAULT NULL,
  `flash_supported` varchar(16) DEFAULT NULL,
  `flash_ver` varchar(16) DEFAULT NULL,
  `lang` varchar(32) DEFAULT NULL,
  `referer_url` varchar(2048) DEFAULT NULL,
  `visit_pos_count` int(11) DEFAULT NULL,
  `visit_first_pos` int(11) DEFAULT NULL,
  `visit_last_pos` int(11) DEFAULT NULL,
  `visit_duration` int(11) DEFAULT NULL,
  `last_pos_id` varchar(64) DEFAULT NULL,
  `visit_session` varchar(128) DEFAULT NULL,
  `user_agent` varchar(512) DEFAULT NULL,
  `formal_flag` int(11) DEFAULT NULL,
  PRIMARY KEY (`log_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `log_study_pos`
--

DROP TABLE IF EXISTS `log_study_pos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `log_study_pos` (
  `pos_id` varchar(64) NOT NULL,
  `log_id` varchar(64) DEFAULT NULL,
  `visit_date` datetime DEFAULT NULL,
  `visit_time` bigint(20) DEFAULT NULL,
  `visit_pos` int(11) DEFAULT NULL,
  `visit_duration` int(11) DEFAULT NULL,
  `action_type` int(11) DEFAULT NULL,
  PRIMARY KEY (`pos_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `log_user_visit`
--

DROP TABLE IF EXISTS `log_user_visit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `log_user_visit` (
  `log_id` varchar(64) NOT NULL,
  `coeus_user_id` bigint(20) DEFAULT NULL,
  `visit_key` varchar(128) DEFAULT NULL,
  `visit_date` datetime DEFAULT NULL,
  `visit_time` bigint(20) DEFAULT NULL,
  `visit_year` int(11) DEFAULT NULL,
  `visit_month` int(11) DEFAULT NULL,
  `visit_day` int(11) DEFAULT NULL,
  `ip_address` varchar(32) DEFAULT NULL,
  `country` varchar(128) DEFAULT NULL,
  `province` varchar(128) DEFAULT NULL,
  `city` varchar(128) DEFAULT NULL,
  `os_name` varchar(16) DEFAULT NULL,
  `os_ver` varchar(16) DEFAULT NULL,
  `display_size` varchar(16) DEFAULT NULL,
  `display_color` varchar(16) DEFAULT NULL,
  `browser_name` varchar(16) DEFAULT NULL,
  `browser_ver` varchar(16) DEFAULT NULL,
  `cookie_supported` varchar(16) DEFAULT NULL,
  `js_supported` varchar(16) DEFAULT NULL,
  `flash_supported` varchar(16) DEFAULT NULL,
  `flash_ver` varchar(16) DEFAULT NULL,
  `lang` varchar(32) DEFAULT NULL,
  `referer_url` varchar(2048) DEFAULT NULL,
  `visit_url` varchar(2048) DEFAULT NULL,
  `visit_duration` int(11) DEFAULT NULL,
  `school_id` bigint(20) DEFAULT '-1',
  `visit_session` varchar(128) DEFAULT NULL,
  `user_agent` varchar(512) DEFAULT NULL,
  `last_pos_id` varchar(64) DEFAULT NULL,
  `visit_pos_count` int(11) DEFAULT '1',
  PRIMARY KEY (`log_id`),
  KEY `log_user_id` (`coeus_user_id`),
  KEY `visit_index` (`visit_key`,`visit_session`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `log_user_visit_pos`
--

DROP TABLE IF EXISTS `log_user_visit_pos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `log_user_visit_pos` (
  `pos_id` varchar(64) NOT NULL,
  `log_id` varchar(64) DEFAULT NULL,
  `visit_date` datetime DEFAULT NULL,
  `visit_time` bigint(20) DEFAULT NULL,
  `visit_duration` int(11) DEFAULT NULL,
  `referer_url` varchar(2048) DEFAULT NULL,
  `visit_url` varchar(2048) DEFAULT NULL,
  PRIMARY KEY (`pos_id`),
  KEY `POS_LOG_ID` (`log_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mooc_live`
--

DROP TABLE IF EXISTS `mooc_live`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mooc_live` (
  `live_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `live_name` varchar(100) DEFAULT NULL,
  `begin_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `duration` varchar(10) DEFAULT NULL,
  `live_introduction` varchar(400) DEFAULT NULL,
  `live_url` varchar(100) DEFAULT NULL,
  `cover_url` varchar(100) DEFAULT NULL,
  `teacher_name` varchar(100) DEFAULT NULL,
  `teacher_pic_url` varchar(100) DEFAULT NULL,
  `teacher_introduction` varchar(400) DEFAULT NULL,
  `delete_flag` int(1) DEFAULT NULL,
  `create_date` datetime DEFAULT NULL,
  PRIMARY KEY (`live_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mooc_unit`
--

DROP TABLE IF EXISTS `mooc_unit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mooc_unit` (
  `unit_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `unit_no` varchar(50) DEFAULT NULL,
  `unit_name` varchar(50) DEFAULT NULL,
  `display_order` int(10) DEFAULT NULL,
  `delete_flag` int(1) DEFAULT NULL,
  `create_date` datetime DEFAULT NULL,
  PRIMARY KEY (`unit_id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mooc_unit_item`
--

DROP TABLE IF EXISTS `mooc_unit_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mooc_unit_item` (
  `item_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `unit_id` bigint(20) DEFAULT NULL,
  `item_name` varchar(400) DEFAULT NULL,
  `video_name` varchar(400) DEFAULT NULL,
  `video_pic` varchar(400) DEFAULT NULL,
  `video_url` varchar(400) DEFAULT NULL,
  `display_order` int(11) DEFAULT NULL,
  `duration` bigint(20) DEFAULT NULL,
  `delete_flag` int(1) DEFAULT NULL,
  `video_flv_url` varchar(400) DEFAULT NULL,
  PRIMARY KEY (`item_id`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mooc_user_info`
--

DROP TABLE IF EXISTS `mooc_user_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mooc_user_info` (
  `user_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `nick_name` varchar(100) DEFAULT NULL,
  `login_name` varchar(100) DEFAULT NULL,
  `password` varchar(100) DEFAULT NULL,
  `role` int(2) DEFAULT NULL,
  `useravatar` varchar(200) DEFAULT NULL,
  `delete_flag` int(1) DEFAULT NULL,
  `create_date` datetime DEFAULT NULL,
  `last_login_date` datetime DEFAULT NULL,
  `last_item_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mooc_user_info`
--

LOCK TABLES `mooc_user_info` WRITE;
/*!40000 ALTER TABLE `mooc_user_info` DISABLE KEYS */;
INSERT INTO `mooc_user_info` (`user_id`, `nick_name`, `login_name`, `password`, `role`, 
    `useravatar`, `delete_flag`, `create_date`, `last_login_date`, `last_item_id`)
VALUES 
    (1,'admin','admin','e10adc3949ba59abbe56e057f20f883e',10,'/images/avatar/default/',0,now(),NULL,NULL);
/*!40000 ALTER TABLE `mooc_user_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mooc_user_study`
--

DROP TABLE IF EXISTS `mooc_user_study`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mooc_user_study` (
  `sid` bigint(20) NOT NULL AUTO_INCREMENT,
  `unit_id` bigint(20) DEFAULT NULL,
  `item_id` bigint(20) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `first_date` datetime DEFAULT NULL,
  `current_position` bigint(20) DEFAULT NULL,
  `max_position` bigint(20) DEFAULT NULL,
  `duration` bigint(20) DEFAULT NULL,
  `is_over` int(11) DEFAULT NULL,
  `first_timedate` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`sid`),
  UNIQUE KEY `item_user_unique` (`item_id`,`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
